window.socialWarfare = window.socialWarfare || {};
( function ( window, $ ) {
	'use strict';
	if ( typeof $ !== 'function' ) {
		if ( typeof jQuery === 'function' ) {
			var $ = jQuery;
		} else {
			console.log(
				'Social Warfare requires jQuery, or $ as an alias of jQuery. Please make sure your theme provides access to jQuery before activating Social Warfare.'
			);
			return;
		}
	}
	function isString( maybeString ) {
		return typeof maybeString === 'string' && maybeString.length > 0;
	}
	socialWarfare.paddingTop = parseInt( $( 'body' ).css( 'padding-top' ) );
	socialWarfare.paddingBottom = parseInt(
		$( 'body' ).css( 'padding-bottom' )
	);
	socialWarfare.initPlugin = function () {
		$( 'body' ).css( {
			paddingTop: socialWarfare.paddingTop,
			paddingBottom: socialWarfare.paddingBottom,
		} );
		socialWarfare.establishPanels();
		socialWarfare.establishBreakpoint();
		if (
			! socialWarfare.panels.staticHorizontal &&
			! socialWarfare.panels.floatingSide &&
			! socialWarfare.panels.floatingHorizontal
		) {
			return;
		}
		socialWarfare.emphasizeButtons();
		socialWarfare.createFloatHorizontalPanel();
		socialWarfare.positionFloatSidePanel();
		socialWarfare.activateHoverStates();
		socialWarfare.handleButtonClicks();
		socialWarfare.updateFloatingButtons();
		socialWarfare.closeLightboxOverlay();
		socialWarfare.preloadPinterestImages();
		if ( typeof swpPinIt === 'object' && swpPinIt.enabled == true ) {
			socialWarfare.createHoverSaveButton();
			socialWarfare.triggerImageListeners();
		}
		setTimeout( function () {
			socialWarfare.checkListeners( 0, 5 );
		}, 2e3 );
		let time = Date.now();
		const scrollDelay = 50;
		$( window ).on( 'scroll', function () {
			if ( time + scrollDelay - Date.now() < 0 ) {
				socialWarfare.updateFloatingButtons();
				time = Date.now();
			}
		} );
	};
	let resizeWait;
	socialWarfare.onWindowResize = function () {
		clearTimeout( resizeWait );
		resizeWait = setTimeout( socialWarfare.initPlugin, 100 );
	};
	socialWarfare.establishPanels = function () {
		socialWarfare.panels = {
			staticHorizontal: null,
			floatingSide: null,
			floatingHorizontal: null,
		};
		socialWarfare.panels.staticHorizontal = $( '.swp_social_panel' ).not(
			'.swp_social_panelSide'
		);
		socialWarfare.panels.floatingSide = $( '.swp_social_panelSide' );
		return socialWarfare.panels;
	};
	socialWarfare.emphasizeButtons = function () {
		if ( typeof socialWarfare.variables.emphasizeIcons === 'undefined' ) {
			return;
		}
		if ( socialWarfare.isMobile() ) {
			return;
		}
		jQuery( '.swp_social_panel:not(.swp_social_panelSide)' ).each(
			function ( i, panel ) {
				jQuery( panel )
					.find( '.nc_tweetContainer:not(.total_shares)' )
					.each( function ( index, button ) {
						if ( index < socialWarfare.variables.emphasizeIcons ) {
							const shareWidth = jQuery( button )
								.find( '.swp_share' )
								.width();
							const iconWidth = jQuery( button )
								.find( 'i.sw' )
								.outerWidth();
							const iconTextWidth = shareWidth + iconWidth + 35;
							const containerWidth = jQuery( button ).width();
							const change =
								1 + ( shareWidth + 35 ) / containerWidth;
							if ( change < 2 ) {
								jQuery( button )
									.addClass( 'swp_nohover' )
									.css( { flex: '2 1 0%' } )
									.find( '.iconFiller' )
									.width( iconTextWidth );
							} else {
								jQuery( button )
									.addClass( 'swp_nohover' )
									.css( { flex: change + ' 1 0%' } )
									.find( '.iconFiller' )
									.width( iconTextWidth );
							}
						}
					} );
			}
		);
	};
	socialWarfare.activateHoverStates = function () {
		socialWarfare.trigger( 'pre_activate_buttons' );
		$(
			'.swp_social_panel:not(.swp_social_panelSide) .nc_tweetContainer'
		).on( 'mouseenter', function () {
			if ( $( this ).hasClass( 'swp_nohover' ) ) {
				return;
			}
			socialWarfare.resetStaticPanel();
			const termWidth = $( this ).find( '.swp_share' ).outerWidth();
			const iconWidth = $( this ).find( 'i.sw' ).outerWidth();
			const containerWidth = $( this ).width();
			const change = 1 + ( termWidth + 35 ) / containerWidth;
			$( this )
				.find( '.iconFiller' )
				.width( termWidth + iconWidth + 25 + 'px' );
			$( this ).css( 'flex', change + ' 1 0%' );
		} );
		$( '.swp_social_panel:not(.swp_social_panelSide)' ).on(
			'mouseleave',
			socialWarfare.resetStaticPanel
		);
	};
	socialWarfare.resetStaticPanel = function () {
		$(
			'.swp_social_panel:not(.swp_social_panelSide) .nc_tweetContainer:not(.swp_nohover) .iconFiller'
		).removeAttr( 'style' );
		$(
			'.swp_social_panel:not(.swp_social_panelSide) .nc_tweetContainer:not(.swp_nohover)'
		).removeAttr( 'style' );
	};
	socialWarfare.handleButtonClicks = function () {
		$( '.nc_tweet, a.swp_CTT' ).off( 'click' );
		$( '.nc_tweet, a.swp_CTT' ).on( 'click', function ( event ) {
			if ( $( this ).parent( '.swp_print' ).length > 0 ) {
				event.preventDefault();
				window.print();
				return;
			}
			if (
				true === $( this ).hasClass( 'pinterest_multi_image_select' )
			) {
				event.preventDefault();
				socialWarfare.openMultiPinterestOverlay( $( this ) );
				return;
			}
			if ( $( this ).parent( '.swp_more' ).length > 0 ) {
				event.preventDefault();
				socialWarfare.openMoreOptions( $( this ) );
				return;
			}
			if ( $( this ).hasClass( 'noPop' ) ) {
				return event;
			}
			if (
				'undefined' === typeof $( this ).data( 'link' ) &&
				false === $( this ).is( '.swp-hover-pin-button' )
			) {
				return event;
			}
			event.preventDefault();
			const href = $( this ).data( 'link' ).replace( '’', "'" );
			let height, width, top, left, instance, windowAttributes, network;
			height = 270;
			width = 500;
			if (
				$( this ).is(
					'.swp_pinterest a, .buffer_link a, .flipboard a, .swp-hover-pin-button'
				)
			) {
				height = 550;
				width = 775;
			}
			if ( $( this ).hasClass( 'nc_tweet' ) ) {
				network = $( this )
					.parents( '.nc_tweetContainer' )
					.data( 'network' );
			} else if ( $( this ).hasClass( 'swp_CTT' ) ) {
				network = 'ctt';
			}
			top = window.screenY + ( window.innerHeight - height ) / 2;
			left = window.screenX + ( window.innerWidth - width ) / 2;
			windowAttributes =
				'height=' +
				height +
				',width=' +
				width +
				',top=' +
				top +
				',left=' +
				left;
			instance = window.open( href, network, windowAttributes );
			socialWarfare.trackClick( network );
		} );
	};
	socialWarfare.openMultiPinterestOverlay = function ( element ) {
		if ( $( '.pinterest-overlay' ).length > 0 ) {
			$( '.pinterest-overlay' ).fadeIn();
			$( '.swp-lightbox-inner' ).scrollTop( 0 );
			return;
		}
		let html = '';
		const pin_data = element.data( 'pins' );
		let pin_images = '';
		pin_data.images.forEach( function ( image ) {
			const share_url =
				'https://pinterest.com/pin/create/button/?url=' +
				pin_data.url +
				'&media=' +
				image +
				'&description=' +
				encodeURIComponent( pin_data.description );
			let pin_html = '';
			pin_html += '<div class="pin_image_select_wrapper">';
			pin_html += '<img class="pin_image" src="' + image + '" />';
			pin_html +=
				'<a class="swp-hover-pin-button" href="' +
				share_url +
				'" data-link="' +
				share_url +
				'">Save</a>';
			pin_html += '</div>';
			pin_images += pin_html;
		} );
		html +=
			'<div class="swp-lightbox-wrapper pinterest-overlay"><div class="swp-lightbox-inner">';
		html += '<i class="sw swp_pinterest_icon top_icon"></i>';
		html += '<div class="swp-lightbox-close"></div>';
		html += '<h5>Which image would you like to pin?</h5>';
		html += '<div class="pin_images_wrapper">';
		html += pin_images;
		html += '</div>';
		html += socialWarfare.buildPoweredByLink();
		html += '</div></div>';
		$( 'body' ).append( html );
		$( '.pinterest-overlay' ).hide().fadeIn();
		socialWarfare.handleButtonClicks();
		let max_height = 999999;
		let iteration = 0,
			images = $( '.pinterest-overlay .pin_images_wrapper img' );
		images.load( function () {
			if ( ++iteration === images.length ) {
				images
					.each( function () {
						if ( $( this ).height() < max_height ) {
							max_height = $( this ).height();
						}
					} )
					.promise()
					.done( function () {
						images.height( max_height + 'px' );
						const number_of_rows = Math.ceil( images.length / 4 );
						for ( i = 0; i < number_of_rows; i++ ) {
							const current_row_images = images.slice(
								i * 4,
								i * 4 + 4
							);
							var max_allowable_width =
								current_row_images.length / 4;
							var total_width = $(
								'.pin_images_wrapper'
							).width();
							var total_images_width = 0;
							current_row_images.each( function () {
								total_images_width =
									total_images_width + $( this ).width();
							} );
							var ratio = total_width / total_images_width;
							current_row_images.each( function () {
								const new_width =
									( ( $( this ).width() * ratio ) /
										total_width ) *
										100 *
										max_allowable_width -
									1;
								$( this )
									.parent()
									.width( new_width + '%' );
								$( this ).height( 'auto' );
							} );
							var height = current_row_images.first().height();
							current_row_images.each( function () {
								$( this )
									.width( $( this ).width() )
									.height( height );
							} );
						}
					} );
			}
		} );
	};
	socialWarfare.buildPoweredByLink = function () {
		let html = '';
		if ( true === socialWarfare.variables.powered_by_toggle ) {
			let anchor_tag_open = '';
			let anchor_tag_close = '';
			if ( false !== socialWarfare.variables.affiliate_link ) {
				anchor_tag_open =
					'<a href="' +
					socialWarfare.variables.affiliate_link +
					'" target="_blank">';
				anchor_tag_close = '</a>';
			}
			html =
				'<div class="swp_powered_by">' +
				anchor_tag_open +
				'<span>Powered by</span> <img src="/wp-content/plugins/social-warfare/assets/images/admin-options-page/social-warfare-pro-light.png">' +
				anchor_tag_close +
				'</div>';
		}
		return html;
	};
	socialWarfare.preloadPinterestImages = function () {
		if ( $( '.pinterest_multi_image_select' ).length < 1 ) {
			return;
		}
		const pin_data = $( '.pinterest_multi_image_select' ).data( 'pins' );
		pin_data.images.forEach( function ( image_url ) {
			const image_object = new Image();
			image_object.src = image_url;
		} );
	};
	socialWarfare.openMoreOptions = function ( element ) {
		if ( $( '.swp-more-wrapper' ).length > 0 ) {
			$( '.swp-more-wrapper' ).fadeIn();
			return;
		}
		const post_id = element
			.parents( '.swp_social_panel' )
			.data( 'post-id' );
		const data = {
			action: 'swp_buttons_panel',
			post_id,
			_ajax_nonce: swp_nonce,
		};
		jQuery.post( swp_ajax_url, data, function ( response ) {
			$( 'body' ).append( response );
			$( '.swp-lightbox-wrapper' ).hide().fadeIn();
			socialWarfare.activateHoverStates();
			socialWarfare.handleButtonClicks();
		} );
	};
	socialWarfare.closeLightboxOverlay = function () {
		$( 'body' ).on( 'click', '.swp-lightbox-close', function () {
			$( '.swp-lightbox-wrapper' ).fadeOut();
		} );
		$( document ).on( 'keyup', function ( e ) {
			if ( e.key === 'Escape' ) {
				$( '.swp-lightbox-wrapper' ).fadeOut();
			}
		} );
	};
	socialWarfare.createFloatHorizontalPanel = function () {
		if ( ! socialWarfare.panels.staticHorizontal.length ) {
			return;
		}
		const floatLocation =
			socialWarfare.panels.staticHorizontal.data( 'float' );
		const mobileFloatLocation =
			socialWarfare.panels.staticHorizontal.data( 'float-mobile' );
		const backgroundColor =
			socialWarfare.panels.staticHorizontal.data( 'float-color' );
		const wrapper = $(
			'<div class="nc_wrapper swp_floating_horizontal_wrapper" style="background-color:' +
				backgroundColor +
				'"></div>'
		);
		let barLocation = '';
		if ( $( '.nc_wrapper' ).length ) {
			$( '.nc_wrapper' ).remove();
		}
		if ( $( '.swp_floating_horizontal_wrapper' ).length ) {
			$( '.swp_floating_horizontal_wrapper' ).remove();
		}
		if (
			floatLocation != 'top' &&
			floatLocation != 'bottom' &&
			mobileFloatLocation != 'top' &&
			mobileFloatLocation != 'bottom'
		) {
			return;
		}
		if ( socialWarfare.isMobile() ) {
			barLocation = mobileFloatLocation;
		} else {
			barLocation = floatLocation;
		}
		wrapper.addClass( barLocation ).hide().appendTo( 'body' );
		socialWarfare.panels.floatingHorizontal =
			socialWarfare.panels.staticHorizontal.first().clone();
		socialWarfare.panels.floatingHorizontal
			.addClass( 'nc_floater' )
			.appendTo( wrapper );
		socialWarfare.updateFloatingHorizontalDimensions();
		$( '.swp_social_panel .swp_count' ).css( {
			transition: 'padding .1s linear',
		} );
	};
	socialWarfare.updateFloatingHorizontalDimensions = function () {
		if ( ! socialWarfare.panels.staticHorizontal.length ) {
			return;
		}
		if ( ! socialWarfare.panels.floatingHorizontal ) {
			return;
		}
		let width = '100%';
		let left = 0;
		const panel = socialWarfare.panels.staticHorizontal;
		let parent = panel.parent();
		if ( parent.hasClass( 'swp-hidden-panel-wrap' ) ) {
			parent = parent.parent();
		}
		if ( 'undefined' !== typeof panel.offset().left ) {
			left = panel.offset().left;
		}
		if ( 'undefined' !== typeof panel.width() ) {
			width = panel.width();
		}
		if ( left == 0 ) {
			left = parent.offset().left;
		}
		if ( width == 100 || width == 0 ) {
			width = parent.width();
		}
		socialWarfare.panels.floatingHorizontal.css( {
			width,
			left,
		} );
	};
	socialWarfare.staticPanelIsVisible = function () {
		let visible = false;
		const scrollPos = $( window ).scrollTop();
		$( '.swp_social_panel' )
			.not( '.swp_social_panelSide, .nc_floater' )
			.each( function ( index ) {
				const offset = $( this ).offset();
				if (
					typeof socialWarfare.floatBeforeContent !== 'undefined' &&
					'1' != socialWarfare.floatBeforeContent
				) {
					const theContent = $( '.swp-content-locator' ).parent();
					if (
						index === 0 &&
						theContent.length &&
						theContent.offset().top >
							scrollPos + $( window ).height()
					) {
						visible = true;
					}
				}
				if (
					$( this ).is( ':visible' ) &&
					offset.top + $( this ).height() > scrollPos &&
					offset.top < scrollPos + $( window ).height()
				) {
					visible = true;
				}
			} );
		return visible;
	};
	socialWarfare.updateFloatingButtons = function () {
		if ( socialWarfare.panels.staticHorizontal.length ) {
			var panel = socialWarfare.panels.staticHorizontal;
		} else if ( socialWarfare.panels.floatingSide.length ) {
			var panel = socialWarfare.panels.floatingSide;
		} else {
			return;
		}
		var location = panel.data( 'float' );
		if ( true == socialWarfare.isMobile() ) {
			var location = panel.data( 'float-mobile' );
		}
		if ( location == 'none' ) {
			return $(
				'.nc_wrapper, .swp_floating_horizontal_wrapper, .swp_social_panelSide'
			).hide();
		}
		if ( socialWarfare.isMobile() ) {
			socialWarfare.toggleMobileButtons();
			socialWarfare.toggleFloatingHorizontalPanel();
			return;
		}
		if ( location == 'right' || location == 'left' ) {
			socialWarfare.toggleFloatingVerticalPanel();
		}
		if ( location == 'bottom' || location == 'top' ) {
			socialWarfare.toggleFloatingHorizontalPanel();
		}
	};
	socialWarfare.toggleMobileButtons = function () {
		socialWarfare.panels.floatingSide.hide();
		const visibility = socialWarfare.staticPanelIsVisible()
			? 'collapse'
			: 'visible';
		$( '.nc_wrapper, .swp_floating_horizontal_wrapper' ).css(
			'visibility',
			visibility
		);
	};
	socialWarfare.toggleFloatingVerticalPanel = function () {
		let direction = '';
		const location = socialWarfare.panels.floatingSide.data( 'float' );
		let visible = socialWarfare.staticPanelIsVisible();
		let offset = '';
		if ( socialWarfare.isMobile() ) {
			return socialWarfare.panels.floatingSide.hide();
		}
		if (
			! socialWarfare.panels.floatingSide ||
			! socialWarfare.panels.floatingSide.length
		) {
			visible = true;
		}
		if (
			socialWarfare.panels.floatingSide.data( 'transition' ) == 'slide'
		) {
			direction = location;
			offset = visible ? '-150px' : '5px';
			socialWarfare.panels.floatingSide.css( direction, offset ).show();
		} else if ( visible ) {
			socialWarfare.panels.floatingSide
				.css( 'opacity', 1 )
				.fadeOut( 300 )
				.css( 'opacity', 0 );
		} else {
			socialWarfare.panels.floatingSide
				.css( 'opacity', 0 )
				.fadeIn( 300 )
				.css( 'display', 'flex' )
				.css( 'opacity', 1 );
		}
	};
	socialWarfare.hasReferencePanel = function () {
		return (
			typeof socialWarfare.panels.staticHorizontal !== 'undefined' &&
			socialWarfare.panels.staticHorizontal.length > 0
		);
	};
	socialWarfare.toggleFloatingHorizontalPanel = function () {
		if ( ! socialWarfare.hasReferencePanel() ) {
			return;
		}
		if ( ! socialWarfare.panels.floatingHorizontal ) {
			return;
		}
		const panel = socialWarfare.panels.floatingHorizontal.first();
		const location = socialWarfare.isMobile()
			? $( panel ).data( 'float-mobile' )
			: $( panel ).data( 'float' );
		let newPadding =
			location == 'bottom'
				? socialWarfare.paddingBottom
				: socialWarfare.paddingTop;
		const paddingProp = 'padding-' + location;
		if ( location == 'off' ) {
			return;
		}
		if ( socialWarfare.staticPanelIsVisible() ) {
			$( '.nc_wrapper, .swp_floating_horizontal_wrapper' ).hide();
			if ( socialWarfare.isMobile() && $( '#wpadminbar' ).length ) {
				$( '#wpadminbar' ).css( 'top', 0 );
			}
		} else {
			newPadding += 50;
			$( '.nc_wrapper, .swp_floating_horizontal_wrapper' ).show();
			if (
				socialWarfare.isMobile() &&
				location == 'top' &&
				$( '#wpadminbar' ).length
			) {
				$( '#wpadminbar' ).css( 'top', panel.parent().height() );
			}
		}
		$( 'body' ).css( paddingProp, newPadding );
	};
	socialWarfare.positionFloatSidePanel = function () {
		let panelHeight, windowHeight, offset;
		const sidePanel = socialWarfare.panels.floatingSide;
		if ( ! sidePanel || ! sidePanel.length ) {
			return;
		}
		if (
			sidePanel.hasClass( 'swp_side_top' ) ||
			sidePanel.hasClass( 'swp_side_bottom' )
		) {
			return;
		}
		panelHeight = sidePanel.outerHeight();
		windowHeight = window.innerHeight;
		if ( panelHeight > windowHeight ) {
			return sidePanel.css( 'top', 0 );
		}
		offset = ( windowHeight - panelHeight ) / 2;
		sidePanel.css( 'top', offset );
	};
	socialWarfare.createHoverSaveButton = function () {
		if ( $( '.tve_editor_page' ).length ) {
			$( '.sw-pinit-button' ).remove();
			$( '.sw-pinit' ).each( function () {
				const inner_content = $( '.sw-pinit' ).contents();
				$( this ).replaceWith( inner_content );
			} );
			return;
		}
		const button = $( document.createElement( 'a' ) );
		button.css( 'display: none' );
		button.addClass( 'swp-hover-pin-button' );
		button.text( 'Save' );
		socialWarfare.hoverSaveButton = $( button );
		return button;
	};
	socialWarfare.triggerImageListeners = function () {
		$( '.swp-content-locator' )
			.parent()
			.find( 'img' )
			.off( 'mouseenter', socialWarfare.renderPinterestSaveButton );
		$( '.swp-content-locator' )
			.parent()
			.find( 'img' )
			.on( 'mouseenter', socialWarfare.renderPinterestSaveButton );
		setTimeout( socialWarfare.triggerImageListeners, 2e3 );
	};
	socialWarfare.getPinMedia = function ( image ) {
		if ( isString( swpPinIt.image_source ) ) {
			return swpPinIt.image_source;
		}
		if ( isString( image.attr( 'src' ) ) ) {
			return image.attr( 'src' );
		}
		const dataSources = [ 'src', 'lazy-src', 'media' ];
		let media = '';
		dataSources.some( function ( maybeSource ) {
			if ( isString( image.data( maybeSource ) ) ) {
				media = image.data( maybeSource );
				return true;
			}
		} );
		if ( media == '' ) {
			return;
		}
		const i = $( '<img>' );
		i.attr( 'src', media );
		return i.prop( 'src' );
	};
	socialWarfare.getPinDescription = function ( image ) {
		if ( isString( image.data( 'pin-description' ) ) ) {
			return image.data( 'pin-description' );
		}
		if ( isString( swpPinIt.image_description ) ) {
			return swpPinIt.image_description;
		}
		if ( isString( image.attr( 'title' ) ) ) {
			return image.attr( 'title' );
		}
		if ( isString( image.attr( 'alt' ) ) ) {
			return image.attr( 'alt' );
		}
		if ( isString( swpPinIt.post_title ) ) {
			return swpPinIt.post_title;
		}
	};
	socialWarfare.enablePinterestSaveButtons = function () {
		jQuery( 'img' ).on( 'mouseenter', function () {
			const pinterestBrowserButtons =
				socialWarfare.findPinterestBrowserSaveButtons();
			if (
				typeof pinterestBrowserButtons !== 'undefined' &&
				pinterestBrowserButtons
			) {
				socialWarfare.removePinterestBrowserSaveButtons(
					pinterestBrowserButtons
				);
			}
		} );
	};
	socialWarfare.toggleHoverSaveDisplay = function ( image ) {
		let top = image.offset().top;
		let left = image.offset().left;
		const vMargin = 15;
		const hMargin = 15;
		const button_size = swpPinIt.button_size || 1;
		const buttonHeight = 24;
		const buttonWidth = 120;
		switch ( swpPinIt.vLocation ) {
			case 'top':
				top += vMargin;
				break;
			case 'middle':
				var offset =
					image.height() / 2 - vMargin / 2 - buttonHeight / 2;
				top += offset;
				break;
			case 'bottom':
				top += image.height() - vMargin - buttonHeight;
				break;
		}
		switch ( swpPinIt.hLocation ) {
			case 'left':
				left += hMargin;
				break;
			case 'center':
				var offset = image.width() / 2 - hMargin / 2 - buttonWidth / 2;
				left += offset;
				break;
			case 'right':
				left += image.width() - hMargin - buttonWidth;
				break;
		}
		socialWarfare.hoverSaveButton.css( {
			top,
			left,
			transform: 'scale(' + button_size + ')',
			'transform-origin': swpPinIt.vLocation + ' ' + swpPinIt.hLocation,
		} );
		image.on( 'mouseleave', function ( event ) {
			if (
				event.relatedTarget != null &&
				event.relatedTarget.className == 'swp-hover-pin-button'
			) {
				return;
			}
			$( '.swp-hover-pin-button' ).remove();
		} );
		$( document.body ).append( socialWarfare.hoverSaveButton );
	};
	socialWarfare.renderPinterestSaveButton = function ( event ) {
		if (
			event.relatedTarget &&
			event.relatedTarget.className == 'swp-hover-pin-button'
		) {
			return;
		}
		if ( $( '.swp-hover-pin-button' ).length > 0 ) {
			return;
		}
		const image = $( event.target );
		if (
			typeof swpPinIt.disableOnAnchors !== undefined &&
			swpPinIt.disableOnAnchors
		) {
			if ( image.parents().filter( 'a' ).length ) {
				return;
			}
		}
		if (
			image.outerHeight() < swpPinIt.minHeight ||
			image.outerWidth() < swpPinIt.minWidth
		) {
			return;
		}
		if ( image.hasClass( 'no_pin' ) || image.hasClass( 'no-pin' ) ) {
			return;
		}
		socialWarfare.toggleHoverSaveDisplay( image );
		const description = socialWarfare.getPinDescription( image );
		const media = socialWarfare.getPinMedia( image );
		const shareLink =
			'http://pinterest.com/pin/create/bookmarklet/?media=' +
			encodeURI( media ) +
			'&url=' +
			encodeURI( document.URL ) +
			'&is_video=false' +
			'&description=' +
			encodeURIComponent( description );
		function openPinterestDialogue( event ) {
			const offsetLeft = ( $( window ).width() - 775 ) / 2;
			const offsetTop = ( $( window ).height() - 550 ) / 2;
			const position = ',top=' + offsetTop + ',left=' + offsetLeft;
			window.open(
				shareLink,
				'Pinterest',
				'width=775,height=550,status=0,toolbar=0,menubar=0,location=1,scrollbars=1' +
					position
			);
			socialWarfare.trackClick( 'pin_image' );
			$( '.swp-hover-pin-button' ).remove();
		}
		$( '.swp-hover-pin-button' ).on( 'click', openPinterestDialogue );
	};
	socialWarfare.findPinterestBrowserSaveButtons = function () {
		let pinterestRed,
			pinterestRed2019,
			pinterestZIndex,
			pinterestBackgroundSize,
			button,
			style;
		pinterestRed = 'rgb(189, 8, 28)';
		pinterestRed2019 = 'rgb(230, 0, 35)';
		pinterestZIndex = '8675309';
		pinterestBackgroundSize = '14px 14px';
		button = null;
		document
			.querySelectorAll( 'span' )
			.forEach( function ( element, index ) {
				style = window.getComputedStyle( element );
				if (
					style.backgroundColor == pinterestRed ||
					style.backgroundColor == pinterestRed2019
				) {
					if (
						style.backgroundSize == pinterestBackgroundSize &&
						style.zIndex == pinterestZIndex
					) {
						button = element;
					}
				}
			} );
		return button;
	};
	socialWarfare.removePinterestBrowserSaveButtons = function ( button ) {
		let pinterestSquare, style, size;
		pinterestSquare = button.nextSibling;
		if (
			pinterestSquare != undefined &&
			pinterestSquare.nodeName == 'SPAN'
		) {
			style = window.getComputedStyle( pinterestSquare );
			size = '24px';
			if (
				style.width.indexOf( size ) === 0 &&
				style.height.indexOf( size ) === 0
			) {
				pinterestSquare.remove();
			}
		}
		button.remove();
	};
	socialWarfare.fetchFacebookShares = function () {
		const url1 =
			'https://graph.facebook.com/v18.0/?fields=og_object{engagement}&id=' +
			swp_post_url;
		const url2 = swp_post_recovery_url
			? 'https://graph.facebook.com/v18.0/?fields=og_object{engagement}&id=' +
			  swp_post_recovery_url
			: '';
		console.log( 'Facebook Share API: ' + url1 );
		console.log( 'Facebook Share API (recovery): ' + url2 );
		$.when( $.get( url1 ), $.get( url2 ) ).then(
			function ( response1, response2 ) {
				var shares, shares1, shares2, data;
				shares1 = socialWarfare.parseFacebookShares( response1[ 0 ] );
				shares2 = 0;
				if ( swp_post_recovery_url ) {
					shares2 = socialWarfare.parseFacebookShares(
						response2[ 0 ]
					);
				}
				shares = shares1;
				if ( shares1 !== shares2 ) {
					shares = shares1 + shares2;
				}
				var data = {
					action: 'swp_facebook_shares_update',
					post_id: swp_post_id,
					share_counts: shares,
				};
				$.post( swp_admin_ajax, data, function ( response ) {
					console.log( response );
				} );
			}
		);
	};
	socialWarfare.parseFacebookShares = function ( response ) {
		if ( 'undefined' === typeof response.og_object ) {
			console.log( 'Facebook Shares: 0' );
			return 0;
		}
		console.log(
			'Facebook Shares: ' + response.og_object.engagement.count
		);
		return parseInt( response.og_object.engagement.count );
	};
	socialWarfare.trigger = function ( event ) {
		$( window ).trigger( $.Event( event ) );
	};
	socialWarfare.trackClick = function ( event ) {
		if ( true === swpClickTracking ) {
			if ( 'function' === typeof ga ) {
				ga(
					'send',
					'event',
					'social_media',
					'swp_' + event + '_share'
				);
			}
			if ( 'object' === typeof dataLayer ) {
				dataLayer.push( { event: 'swp_' + event + '_share' } );
			}
		}
	};
	socialWarfare.checkListeners = function ( count, limit ) {
		if ( count > limit ) {
			return;
		}
		const panel = $( '.swp_social_panel' );
		if ( panel.length > 0 && panel.find( '.swp_pinterest' ) ) {
			socialWarfare.handleButtonClicks();
			return;
		}
		setTimeout( function () {
			socialWarfare.checkListeners( ++count, limit );
		}, 2e3 );
	};
	socialWarfare.establishBreakpoint = function () {
		const panel = $( '.swp_social_panel' );
		socialWarfare.breakpoint = 1100;
		if (
			( panel.length && panel.data( 'min-width' ) ) ||
			panel.data( 'min-width' ) == 0
		) {
			socialWarfare.breakpoint = parseInt( panel.data( 'min-width' ) );
		}
	};
	socialWarfare.isMobile = function () {
		return $( window ).width() < socialWarfare.breakpoint;
	};
	$( document ).ready( function () {
		socialWarfare.initPlugin();
		socialWarfare.panels.floatingSide.hide();
		$( window ).on( 'resize', socialWarfare.onWindowResize );
		if ( 'undefined' !== typeof swpPinIt && swpPinIt.enabled ) {
			socialWarfare.enablePinterestSaveButtons();
		}
	} );
	$( window ).on( 'load', function () {
		if ( 'undefined' !== typeof swpPinIt && swpPinIt.enabled ) {
			socialWarfare.enablePinterestSaveButtons();
		}
		window.clearCheckID = 0;
	} );
} )( this, jQuery );
//# sourceMappingURL=script.min.js.map
