<!DOCTYPE html>
<html lang="en-US" xmlns="http://www.w3.org/1999/xhtml" itemscope itemtype="http://schema.org/WebPage">
<head>
    <title>Player</title>
    <meta charset="UTF-8"/>
    <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link href="https://fonts.googleapis.com/css?family=Dosis" rel="stylesheet" type="text/css"/>
    <script src='https://content.jwplatform.com/libraries/lqsWlr4Z.js'></script>
  <link rel='stylesheet' href='https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/4.4.1/css/bootstrap.min.css'>
 <style>
body {
  background-color: #111;
}
   
:root {
	--bg-red: #F8AF3F;
	--bg-white: #F7F7F7;
	--bg-black: #222222;
}

/*
RGBA em idle.
 */
.jwplayer.jw-skin-netflix.jw-state-idle .jw-controls,
.jwplayer.jw-skin-netflix.jw-state-complete .jw-controls{
	background: rgba(0, 0, 0, .7);
}

/*
Botão play em idle.
 */
.jwplayer.jw-skin-netflix.jw-state-idle .jw-display-controls .jw-display-icon-container {
	color: var(--bg-red);
	background: none;
	margin-bottom: 150px;
	border-radius: 50%;
	width: 100px;
	height: 100px;
	-webkit-animation-name: scaling;
	-webkit-animation-duration: 0.6s;
	-webkit-animation-timing-function: linear;
	-webkit-animation-iteration-count: infinite;
	-webkit-animation-direction: alternate;
}

.jwplayer.jw-skin-netflix.jw-state-idle .jw-display-controls .jw-display-icon-container .jw-icon {
	color: #1e1e1e;
	width: 60px;
	height: 60px;
	padding: 20px;
}

.jwplayer.jw-skin-netflix.jw-state-idle .jw-display-controls .jw-display-icon-container {
	margin-bottom: -2.5rem;
	background-color: rgba(0, 0, 0, .4);
	border: solid 0.125rem var(--bg-white);
	height: 75px;
	width: 75px;
}

.jwplayer.jw-skin-netflix.jw-state-idle:hover .jw-display-controls .jw-display-icon-container {
	background-color: rgba(0, 0, 0, .5);
}

.jwplayer.jw-skin-netflix.jw-state-idle .jw-display-controls .jw-display-icon-container .jw-icon {
	color: var(--bg-red);
	height: 50px;
	width: 50px;
	padding: 12px;
}

.jwplayer.jw-skin-netflix.jw-state-idle .jw-display-controls .jw-display-icon-container:hover {
	background-color: rgba(0, 0, 0, .4);
}

.jwplayer.jw-skin-netflix.jw-state-idle .jw-display-controls .jw-display-icon-container .jw-icon:hover {
	color: var(--bg-red);
}

/*
Posição do play em idle.
*/
.jwplayer.jw-skin-netflix.jw-state-idle .jw-display {
	height: 50%;
}

.jwplayer.jw-skin-netflix.jw-state-idle .jw-display-container {
	vertical-align: bottom;
}

.jwplayer.jw-skin-netflix .jw-display-controls .jw-display-icon-container .jw-icon:hover {
	color: var(--bg-red);
}

.jwplayer.jw-skin-netflix.jw-state-paused .jw-controls {
	background-color: rgba(0, 0, 0, .1);
}

/*
Amplia a imagem e adiciona transições.
*/
.jwplayer.jw-skin-netflix .jw-preview {
	width: calc(100% + 50px);
	background-size: calc(100% + 60px);
	transition: opacity 0.35s, transform 0.35s;
	transform: translate3d(-40px, 0, 0);
}

.jwplayer.jw-skin-netflix:hover .jw-preview {
	transform: translate3d(0, 0, 0);
}

/*
Deslizar a imagem em -40px.
*/
.jwplayer.jw-skin-netflix.jw-state-complete:hover .jw-preview {
	transform: translate3d(-40px, 0, 0);
}

/*
Mudar a cor da barra de controle e alterar a cor do ícone em idle.
*/
.jwplayer.jw-skin-netflix .jw-display {
	padding-bottom: 45px;
}

.jwplayer.jw-skin-netflix .jw-controls::after {
	background: none;
}

.jwplayer.jw-skin-netflix .jw-controlbar {

}

.jwplayer.jw-skin-netflix .jw-controlbar .jw-button-container .jw-button-color {
	color: var(--bg-white);
}

.jwplayer.jw-skin-netflix.jw-state-paused .jw-controlbar .jw-button-container .jw-button-color {
	color: var(--bg-white);
}

.jwplayer.jw-skin-netflix .jw-controlbar .jw-button-container .jw-button-color:hover {
	color: var(--bg-red);;
}

/*
Toltips mais perto da barra, alterar cores e remover sombras.
*/
.jwplayer.jw-skin-netflix .jw-controlbar .jw-tooltip {
	bottom: 90%;
	box-shadow: none!important;
}

.jwplayer.jw-skin-netflix .jw-controlbar .jw-tooltip.jw-open {
	border-radius: 3px;
	color: var(--bg-black);
}

.jwplayer.jw-skin-netflix .jw-controlbar .jw-tooltip .jw-text {
	background-color: VAR(--bg-black);
	border-radius: 3px;
	border: 0;
}

.jwplayer.jw-skin-netflix .jw-controlbar .jw-text {
	color: var(--bg-white);
}

.jwplayer.jw-skin-netflix .jw-time-tip .jw-text{
	color: var(--bg-black);
}

.jwplayer.jw-skin-netflix .jw-volume-tip {
	margin-bottom: -40px;
}

/*
Tooltip timeslider e botões de qualidade e legenda.
*/
.jwplayer.jw-skin-netflix .jw-settings-topbar-buttons .jw-tooltip-captions, 
.jwplayer.jw-skin-netflix .jw-settings-topbar-buttons .jw-tooltip-quality {
	color: var(--bg-black);
}

.jwplayer.jw-skin-netflix .jw-settings-topbar-buttons .jw-tooltip-captions .jw-text,
.jwplayer.jw-skin-netflix .jw-settings-topbar-buttons .jw-tooltip-quality .jw-text,
.jwplayer.jw-skin-netflix .jw-time-tip .jw-reset {
	border-radius: 3px;
	background-color: var(--bg-black);
	color: var(--bg-white);
}

.jwplayer.jw-skin-netflix .jw-time-tip {
	color: var(--bg-black);
}

/*
Controle de volume.
*/
.jwplayer.jw-skin-netflix .jw-overlay .jw-slider-volume .jw-slider-container .jw-knob {
	background-color: var(--bg-red);
}

.jwplayer.jw-skin-netflix .jw-overlay .jw-slider-volume .jw-slider-container .jw-buffer,
.jwplayer.jw-skin-netflix .jw-overlay .jw-slider-volume .jw-slider-container .jw-rail {
	background-color: var(--bg-black);
	width: 0.2rem;
}

.jwplayer.jw-skin-netflix .jw-overlay .jw-slider-volume .jw-slider-container .jw-progress{
	background-color: var(--bg-red);
	width: 0.2rem;
}

/*
Tamanho e cor da slider.
*/
.jwplayer.jw-skin-netflix .jw-controlbar .jw-slider-time .jw-slider-container .jw-rail {
	background-color: var(--bg-black);
}
.jwplayer.jw-skin-netflix .jw-controlbar .jw-slider-time .jw-slider-container .jw-buffer {
	background-color: #404040;
}

.jwplayer.jw-skin-netflix .jw-controlbar .jw-slider-time .jw-slider-container .jw-knob,
.jwplayer.jw-skin-netflix .jw-controlbar .jw-slider-time .jw-slider-container .jw-progress {
	background-color: var(--bg-red);
}

.jw-skin-netflix .jw-slider-horizontal .jw-rail,
.jw-skin-netflix .jw-slider-horizontal .jw-buffer,
.jw-skin-netflix .jw-slider-horizontal .jw-progress {
	height: 0.3rem;
}

/*
Cor do menu de configurações.
*/
.jwplayer.jw-skin-netflix .jw-settings-menu {
	background-color: var(--bg-black);
	border-radius: 3px;
	max-width: 10rem;
	max-height: 15rem;
}

.jwplayer.jw-skin-netflix .jw-settings-menu .jw-settings-topbar .jw-icon:hover {
	color: var(--bg-red);
}

.jwplayer.jw-skin-netflix .jw-settings-menu .jw-settings-content-item:hover,
.jwplayer.jw-skin-netflix .jw-settings-menu .jw-settings-item-active {
	color: var(--bg-red);
}

.jwplayer.jw-skin-netflix .jw-settings-menu .jw-settings-item-active::before {
	
}

/*
Ícone Taxas de Reprodução e configurações de legendas.
*/

 .jw-svg-icon-playback-rate path {
	color: var(--bg-white);
}

.jwplayer.jw-skin-netflix .jw-settings-menu .jw-submenu-topbar {
	display: none;
}

/*
Player responsivo jw8.
*/
.jwplayer.jw-skin-netflix.jw-breakpoint-6 .jw-volume-tip,
.jwplayer.jw-skin-netflix.jw-breakpoint-5 .jw-volume-tip,
.jwplayer.jw-skin-netflix.jw-breakpoint-4 .jw-volume-tip,
.jwplayer.jw-skin-netflix.jw-breakpoint-3 .jw-volume-tip,
.jwplayer.jw-skin-netflix.jw-breakpoint-2 .jw-volume-tip,
.jwplayer.jw-skin-netflix.jw-breakpoint-1 .jw-volume-tip,
.jwplayer.jw-skin-netflix.jw-breakpoint-0 .jw-volume-tip {
	margin-bottom: -20px;
}

/*
Animações do botão.
 */
@-webkit-keyframes scaling  {
	From {
		-webkit-transform: scale(1.0);
	}
	To {
		-webkit-transform: scale(1.1);
	}
}

/*
ícones do player.
 */
.jw-svg-icon-buffer {
	color: var(--bg-red);
}

/*
ícone de Play
 */
.jw-state-paused .jw-svg-icon-play path {
	display: none;
}

.jw-state-paused .jw-svg-icon-play {
	background-image: url('data:image/png;base64,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');
	background-size: contain;
	background-repeat: no-repeat;
}

.jw-state-paused .jw-icon-playback:hover .jw-svg-icon-play {
	background-image: url('data:image/png;base64,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');
}

/*
ícone de Puase.
 */
.jw-svg-icon-pause path {
	display: none;
}

.jw-svg-icon-pause {
	background-image: url('data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAgAAAAIABAMAAAAGVsnJAAAAFVBMVEVHcEz///////////////////////+3ygHaAAAABnRSTlMA5rszNi5wpjsGAAACM0lEQVR42u3QsQmAMABFwYA6gBb2aawdISNkBS3cfwR3+CgI3lvgwZUiSZIkSZIkSZIkSZIkSZIkSZIkSZIk6XfVOWrp2W5Kf68BbFdWy3bjmu3OrwEcO4CoAQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAMBjAC3bjZ8DqHPU0kOA9FckSZIkSZIkSZIkSZIkSZIkSZIkSZIk/a4bzQB0P8F2LcoAAAAASUVORK5CYII=');
	background-size: contain;
	background-repeat: no-repeat;
}

.jw-icon-playback:hover .jw-svg-icon-pause {
	background-image: url('data:image/png;base64,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');
}

/*
Ícone de Rewind.
 */
.jw-svg-icon-rewind path {
	display: none;
}

.jw-svg-icon-rewind {
	background-image: url('data:image/png;base64,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');
	background-size: contain;
	background-repeat: no-repeat;
}

.jw-icon-rewind:hover .jw-svg-icon-rewind {
	background-image: url('data:image/png;base64,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');
}

/*
Ícone de Configuração.
 */
.jw-svg-icon-settings path {
	display: none;
}

.jw-svg-icon-settings {
	background-image: url('data:image/png;base64,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');
	background-size: contain;
	background-repeat: no-repeat;
}

.jw-icon-settings:hover .jw-svg-icon-settings {
	background-image: url('data:image/png;base64,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');
}

/*
Ícone de Qualidade.
 */
.jw-svg-icon-quality-100 path {
	display: none;
}

.jw-svg-icon-quality-100 {
	background-image: url('data:image/png;base64,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');
	background-size: contain;
	background-repeat: no-repeat;
}

/*
Ícone de Fechar.
 */
.jw-svg-icon-close path {
	display: none;
}

.jw-svg-icon-close {
	background-image: url('data:image/png;base64,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');
	background-size: contain;
	background-repeat: no-repeat;
}

.jw-settings-close:hover .jw-svg-icon-close {
	background-image: url('data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAgAAAAIACAYAAAD0eNT6AAAgAElEQVR4Xu3dz6se15kn8FPvTaS0N96lNwaDd4bpnpVhyEIOQ3oW08HICooUm4aBbmYZmNVMN/SqYTL5H7qhIdixI2KLkJ5NxCBr4TF4NfSAdwaBNp3ZtDfBUqK3hvdy7diKr269derHeer5eOu3Tj3n85yr+tap90dX/EeAAAECBAikE+jSzdiECRAgQIAAgSIAWAQECBAgQCChgACQsOmmTIAAAQIEBABrgAABAgQIJBQQABI23ZQJECBAgIAAYA0QIECAAIGEAgJAwqabMgECBAgQEACsAQIECBAgkFBAAEjYdFMmQIAAAQICgDVAgAABAgQSCggACZtuygQIECBAQACwBggQIECAQEIBASBh002ZAAECBAgIANYAAQIECBBIKCAAJGy6KRMgQIAAAQHAGiBAgAABAgkFBICETTdlAgQIECAgAFgDBAgQIEAgoYAAkLDppkyAAAECBAQAa4AAAQIECCQUEAASNt2UCRAgQICAAGANECBAgACBhAICQMKmmzIBAgQIEBAArAECBAgQIJBQQABI2HRTJkCAAAECAoA1QIAAAQIEEgoIAAmbbsoECBAgQEAAsAYIECBAgEBCAQEgYdNNmQABAgQICADWAAECBAgQSCggACRsuikTIECAAAEBwBogQIAAAQIJBQSAhE03ZQIECBAgIABYAwQIECBAIKGAAJCw6aZMgAABAgQEAGuAAAECBAgkFBAAEjbdlAkQIECAgABgDRAgQIAAgYQCAkDCppsyAQIECBAQAKwBAgQIECCQUEAASNh0UyZAgAABAgKANUCAAAECBBIKCAAJm27KBAgQIEBAALAGCBAgQIBAQgEBIGHTTZkAAQIECAgA1gABAgQIEEgoIAAkbLopEyBAgAABAcAaIECAAAECCQUEgIRNN2UCBAgQICAAWAMECBAgQCChgACQsOmmTIAAAQIEBABrgAABAgQIJBQQABI23ZQJECBAgIAAYA0QIECAAIGEAgJAwqabMgECBAgQEACsAQIECBAgkFBAAEjYdFMmQIAAAQICgDVAgAABAgQSCggACZtuygQIECBAQACwBggQIECAQEIBASBh002ZAAECBAgIANYAAQIECBBIKCAAJGy6KRMgQIAAAQHAGiBAgAABAgkFBICETTdlAgQIECAgAFgDBAgQIEAgoYAAkLDppkyAAAECBAQAa4AAAQIECCQUEAASNt2UCRAgQICAAGANECBAgACBhAICQMKmmzIBAgQIEBAArAECBAgQIJBQQABI2HRTJkCAAAECAoA1QIAAAQIEEgoIAAmbbsoECBAgQEAAsAYIECBAgEBCAQEgYdNNmQABAgQICADWAAECBAgQSCggACRsuikTIECAAAEBwBogQIAAAQIJBQSAhE03ZQIECBAgIABYAwQIECBAIKGAAJCw6aZMgAABAgQEAGuAAAECBAgkFBAAEjbdlAkQIECAgABgDRAgQIAAgYQCAkDCppsyAQIECBAQAKwBAgQIECCQUEAASNh0UyZAgAABAgKANUCAAAECBBIKCAAJm27KBAgQIEBAALAGCBAgQIBAQgEBIGHTTZkAAQIECAgA1gABAgQIEEgoIAAkbLopEyBAgAABAcAaIECAAAECCQUEgIRNN2UCBAgQICAAWAMECBAgQCChgACQsOmmTIAAAQIEBABrgAABAgQIJBQQABI23ZQJECBAgIAAYA0QIECAAIGEAgJAwqabMgECBAgQEACsAQIECBAgkFBAAEjYdFMmQIAAAQICgDVAgAABAgQSCggACZtuygQIECBAQACwBggQIECAQEIBASBh002ZAAECBAgIANYAAQIECBBIKCAAJGy6KRMgQIAAAQHAGiBAgAABAgkFBICETTdlAgQIECAgAFgDBAgQIEAgoYAAkLDppkyAAAECBAQAa4AAAQIECCQUEAASNt2UCRAgQICAAGANECBAgACBhAICQMKmmzIBAgQIEBAArAECBAgQIJBQQABI2HRTJkCAAAECAoA1QIAAAQIEEgoIAAmbbsoECBAgQEAAsAYIECBAgEBCAQEgYdNNmQABAgQICADWAAECBAgQSCggACRsuikTIECAAAEBwBogQIAAAQIJBQSAhE03ZQIECBAgIABYAwQIECBAIKGAAJCw6aZMgAABAgQEAGuAAAECBAgkFBAAEjbdlAkQIECAgABgDRAgQIAAgYQCAkDCppsyAQIECBAQAKwBAgQIECCQUEAASNj0Nafc/+z6pUeX/uXVvu/+quu6l/q+f/bJerqu+6Tv+w+7rv/7S4/++N3u+7cerVmzcxM4VuCwzg/HPLr0//5L6fr/3O/LC181hrV+rKzXTykgAEypaaynCjx858qL+677266UHxxBdafr+x9evnbvoyOO8VICqwo8+vnLL+135b+XUr4ztJC+lJ/u+v7vrPWhYl5XKyAA1Ao6fpDA4eJfdru3+77/k0EHfOFF3a58/Ljv/+KZq/feP/ZYryewtMCjX3z73/V9/8Z5d/1Pq6frun8u+/0NIWDpruU8nwCQs++Lzrrm4v+FQu/vu/41IWDR1jnZkQKHi//+cf9WKeX5Iw/9/OWHwFse998VAsYKOm6ogAAwVMrrRgkctkL7k+4fxtz5f8UJH+y7/oYQMKoVDppZYIqL/2clHkJA97ty89L33vtw5rINn1hAAEjc/Lmnfnrnf9L9csxW6FNqsxMwd+OMf7RAzbb/eSezE3B0GxxwpIAAcCSYlw8TmGjb/7yTCQHD2uBVCwhMeef/ZLmH9wR0j/u/tBOwQCMTnkIASNj0uac8053/k2Xf3510Ny+9cveDuedjfALnCcx58f/i4wDvCbAG5xAQAOZQTTzmzHf+X5L16YDEC62Bqc+x7X/u4wCfDmig49srQQDYXk9Xm9GSF/8vTNJOwGodz3viJS/+X9wJ8MbAvGtujpkLAHOoJhxzpYv/Z9JCQMI1t9aUTz/Z8rXy1sRvbh00Hd8TMIjJiwYKCAADobzsfIGVL/6nhZ1+bKrrXveeACt1ToE1L/6f7wR4HDBni1ONLQCkavf0k23h4u9xwPR9NeIfCizxhr+h7nYChkp53dMEBADrY7TAQu/2P7Y+jwOOFfP6CwVauPN/skhfFnRh27zgAgEBwBIZJdDYnf+TcxACRnXVQV8l0OLF3+MAa3UKAQFgCsVkY0z89b5z6QkBc8kmGvfsV/1u1Xy3/9xcdgLmFt7u+ALAdns7y8wa3fY/b65CwCyrIMegLd/5f9XjAF8WlGNdTjlLAWBKzY2P1fi2//khYF+u+yrVjS/OiacX4c7/D0KATwdMvAq2P5wAsP0eTzLDoBf/z+Z+fycETLIOMgwS8eLvPQEZVub0cxQApjfd3Ij9z65f+vTrv/7HrpQfBJ6cxwGBm7dU6ZEv/p8Z9aX89Bu//eZ/6r5/69FSbs4TU0AAiNm3Rat+ePvKjb7v3lr0pPOc7MHupLvuy4LmwY0+akuf86+17Lr+5uWr996uHcfx2xYQALbd30lm9+m7L/+qlPKdSQZbf5AHu3255j0B6zeipQrO7vzfKaU811JdFbXc6fr+h5ev3fuoYgyHblxAANh4g6eY3sPb3/7Xvu+fnWKsRsawE9BII1ooYwvb/k86dl33SSnlR5ev3v1xC8ZqaFNAAGizL01V9em7L/dNFTRNMULANI6hRznb9j98zn8rd/6f9+PwXoA/evW910I3SPGzCggAs/JuY/CNBoBDc4SAbSzRUbPY4Lb/lxwOvxdw+erdPx2F46AUAgJAijbXTXLDAeAA49MBdcsj5NFbesPfeQ0QAEIuzUWLFgAW5Y55so0HgNOdgH3X33jm6r33Y3ZI1ccIbHnb/4sOAsAxqyLnawWAnH0/atYJAsDpTsC+618TAo5aGuFenOHO/7OmeA9AuOW5eMECwOLk8U64wU8BnNcEISDe8hxc8W9uX/nWru/ebPmHfQZP5oIX+hTAVJLbHkcA2HZ/J5ndxr4H4CITjwMuEgr4/88u/ocvxtncu/3Paced3b78je+7CLhYFyxZAFgQO+qpNvRNgENbYCdgqFSA12W68/+sHb4JMMDCbKBEAaCBJrRewuG3AB5+/df/tKFvAxxCLgQMUWr8NRkv/qWUO5d/+80/91sAjS/OBsoTABpoQoQSTn8N8KT7Zb8vL0Sod6IaPQ6YCHKNYRJu+5fDO//Lfn/DVwCvseLinVMAiNez1Sre4lemDsC0EzAAqbWXJL3z950WrS3ExusRABpvUGvlHT5G1ff9G8l2AoSA1hbiU+px8Q/ULKWuKiAArMof8+RJQ4DHAQGWa9aLv++wCLA4GyxRAGiwKRFKyvSFKl/oh52AhhenNdlwc5TWpIAA0GRbYhSVdCdACGhwebr4N9gUJTUvIAA036K2C/QPb9v9yVCdNZihy+Y4h4AAMIdqsjH9A5ys4Q1N1y5UQ81QSjgBASBcy9osOOs/xLuT7ualV+5+0GZXtl2V4Lnt/prd/AICwPzGac6Q9R3YQsDySzxr4PRu/+XX2pbPKABsubsrzC1jCOh25eOu6163E7DMgkt68fcx1GWWV6qzCACp2r3MZDOGgFLK/d2+XPfra/OuscO3UfZfK2/5Iqp5nY2eQ0AAyNHnxWeZMQSc7gT8rtwUAuZZbkkv/u7851lORi2lCACWwWwCGUPA6U6ANwZOvqZc/CcnNSABAcAamFdACJjXN8PoSX+Eyp1/hsW98hztAKzcgAynP/u41q1SynMZ5nuYozcGTtNpd/7TOBqFwFcJCADWxSICWT+z7XHA+OXlzn+8nSMJDBEQAIYoec0kAhl3ArwnYNzSyXrx3510132cdNyacdTxAgLA8WaOqBAQAirwkhxq2z9Jo01zdQEBYPUW5CvA3V2+ng+dsUdFQ6W8jkC9gABQb2iEEQJnIeCdTG8M9GVBT18oaYPhvlzz3REj/hFxSLWAAFBNaICxAklDwAPPef9wxaS9+HvmP/afD8dNICAATIBoiPEC/uEfb7eVI5MGQV8YtZUFHHgeAkDg5m2l9KQhwAWglJK09w92tv238s9X6HkIAKHbt53i014IEm8BJ+254Ledf7bCz0QACN/C7Uwg68e/Mr4nIO22v1+M3M4/WBuYiQCwgSZuaQpZ7wr3Xf/aM1fvvb+lXp43l7Qf9XPxz7C8Q81RAAjVrhzF2gnYbp/TXvz9QuR2F3XgmQkAgZu35dKT7gRs+hfg0l783flv+Z+q0HMTAEK3b9vFJw0B97f4OODws9AnXfeTfl9e2Paq/dLsvOEvUbMjTlUAiNi1RDVnfRyw7/obW3lPQNo7f9v+if6lijlVASBm31JVnXQnYBOPA1z8U/2pmmwwAQEgWMOylps0BIR+HHDY9t/13ZullOcTrVvb/omaHX2qAkD0Diaq/3A32ff9G8meI4fcCch48e925eOu616/9MrdDxL9WZpqYAEBIHDzMpaedUs50hsDM178T3/p0TP/jP8khZ6zABC6fTmLT7oTEOJxgICW82/SrGMKCAAx+5a+6qQhoOnHAS7+6f8sAQQTEACCNUy5vxdwwWlnNSQNZLb921mCKhkhIACMQHNIOwJCwPq90IP1e6ACAmMEBIAxao5pSiDpBaiJxwFJ7UO8H6OpP1LFNCkgADTZFkUdK+BCdKxY/euTbvs3Ebzqu2cEAqUIAFbBZgSSXpBWeQ4tcG3mz8ZEEgsIAImbv8WpZ70wLfkZ9KzGkb6LYYt/2+Y0vYAAML2pEVcWyHqBWiIEZN1lcfFf+Y/a6WcREABmYTXo2gK+jW76DiT9ZUZv+Jt+KRmxEQEBoJFGKGN6ASFgOtOkF39v+JtuCRmpQQEBoMGmKGk6gbQhYF+uX/reex9OIeniP4WiMQi0JyAAtNcTFU0s4D0B40GT/gyzO//xS8aRgQQEgEDNUup4gbMQcKuU8tz4UcIdeX9XsRPgzj9cvxVM4CgBAeAoLi+OLGAnYHj3XPyHW3klgagCAkDUzql7lEDSEPBgty/Xhr4nIOu2/+6ku37plbsfjFpYDiIQUEAACNg0JdcJpH0ccNLdvOgCl/XO38W/7m/K0TEFBICYfVN1pUDSEPDUN7cl/cTEAxf/yj8mh4cVEADCtk7htQIZt7q7rvuklPKjst//4vK1ex8dDB++c+XFstu9Ukr5677vn611DXT8UY9GAs1LqQQGCQgAg5i8aKsCSXcCyiEI9H1/+j0BXde9lOzCf5i2O/+t/lGb12ABAWAwlRduVSDjTsBWezlwXi7+A6G8bNsCAsC2+2t2AwWEgIFQ8V9W9d0I8advBgR+LyAAWA0EzgSSfkQwU//vL/GLiZlAzTW2gAAQu3+qn1gg6cfgJlZscjh3/k22RVFrCggAa+o7d5MCHgc02Zaaolz8a/Qcu1kBAWCzrTWxGgE7ATV6TR1r27+pdiimJQEBoKVuqKUpASGgqXaMKcad/xg1x6QREADStNpExwh4HDBGrYljXPybaIMiWhYQAFrujtqaELAT0EQbjinCtv8xWl6bVkAASNt6Ez9GQAg4RmvV17r4r8rv5JEEBIBI3VLrqgK+J2BV/iEnd/EfouQ1BM4EBABLgcARAkLAEVjLvvT+vutfe+bqvfeXPa2zEYgrIADE7Z3KVxIQAlaCP/+07vyba4mCIggIABG6pMbmBISAZlrizr+ZVigkmoAAEK1j6m1G4BAC+r5/o9+XF5opKlchLv65+m22EwsIABODGi6XgJ2A1fr9YN/1NzzzX83fiTcgIABsoImmsK6AELC4vzv/xcmdcIsCAsAWu2pOiwv85vaVb5103U88Dpid3sV/dmInyCIgAGTptHnOLnAIAbu+e7uU8tzsJ8t5Atv+Oftu1jMJCAAzwRo2p8BZCHizlPJ8ToHZZu3OfzZaA2cVEACydt68ZxMQAiandfGfnNSABEoRAKwCAjMIeGPgZKi2/SejNBCBLwsIAFYEgZkEhIBqWHf+1YQGIHC+gABgdRCYUUAIGI3rzn80nQMJDBMQAIY5eRWB0QJnIeCWTwcMJnTxH0zlhQTGCwgA4+0cSWCwgJ2AwVS2/QdTeSGBOgEBoM7P0QQGC9gJuJDKnf+FRF5AYDoBAWA6SyMRuFBACDiXyMX/wtXjBQSmFRAApvU0GoELBU6/Nrjs/mff989e+OIEL+i67pPHZf8f/bBPgmabYlMCAkBT7VBMFoGHt7/9X/u+/x9Z5vu0eXZd998uX737YxYECCwrIAAs6+1sBE4FHr5z5cWy2/1vuwDlQdf3/+HytXsfWRoECCwrIAAs6+1sBD4X+PTdl39VSvlOcpI733j1vT9LbmD6BFYREABWYXdSAqUIAKerQADwx0BgJQEBYCV4p80t4BHA5/33CCD3n4LZryggAKyI79R5BbwJ8Pe99ybAvH8HZr6ugACwrr+zJxTwMcAvN93HABP+EZhyEwICQBNtUEQWAV8EdG6nfRFQlj8C82xGQABophUK2bqAi/+FHRYCLiTyAgLTCQgA01kaicC5An4MaPDi8GNAg6m8kECdgABQ5+doAhcKuPO/kOjJF9gJOJrMAQSOFxAAjjdzBIHBAu78B1MJAaOpHEhgnIAAMM7NUQQuFHDxv5Doohd4HHCRkP9PoEJAAKjAcyiB8wRc/CdbGx4HTEZpIAJfFhAArAgCEwscPue/67s3SynPTzx01uHsBGTtvHnPKiAAzMpr8GwCLv6zdVwImI3WwFkFBICsnTfvyQXOLv5vl1Kem3xwAx4EPA6wDghMKCAATIhpqLwCp1/v23U/6fflhbwKi8zcTsAizE6SQUAAyNBlc5xVwBv+ZuX9qsGFgMXJnXCLAgLAFrtqTosJuPgvRv3kiTwOWI3eibciIABspZPmsbjA4eLf9/0btv0Xp//shHYCVqN34i0ICABb6KI5LC7gzn9x8vNOKAQ00wqFRBMQAKJ1TL2rC7j4r96CJwu4vzvpbl565e4HzVWmIAINCwgADTdHae0JuPi315OziuwENNsahbUqIAC02hl1NSfg4t9cS+wENN8SBbYsIAC03B21NSPw6Ocvv9R/rbzlDX/NtOS8QjwOaL5FCmxFQABopRPqaFbAxb/Z1ggB4Vqj4JYEBICWuqGW5gQOF//9rtzywz7Nteaigu7v9uX6pe+99+FFL/T/CWQVEACydt68LxRw538hUesvEAJa75D6VhUQAFbld/JWBVz8W+3M0XV5T8DRZA7IIiAAZOm0eQ4WsO0/mCrKC+0EROmUOhcVEAAW5Xay1gXc+bfeodH1CQGj6Ry4VQEBYKudNa+jBXzO/2iyaAd4HBCtY+qdVUAAmJXX4FEEbPtH6VR1nXYCqgkNsBUBAWArnTSP0QIu/qPpoh74YHfSXffbAVHbp+6pBASAqSSNE1LgbNv/8Dn/50JOYGTRXdd90vf96Wfku657qe/7Z0cOFfUwISBq59Q9mYAAMBmlgaIJZLzzP1z4Syk/Kvv9Ly5fu/fRoWcP37nyYtntXiml/HWyIPBgty/XfFlQtL9c9U4lIABMJWmcUAJJ7/wf7Lv+xjNX773/Vc36ze0r39r13ZvJvvXQTkCov1zFTikgAEypaawQAkkv/oPeAZ/0Y5BCQIi/XEVOLSAATC1qvKYFkn7U76it7oyPRkopQkDTf7mKm0NAAJhD1ZhNCiS9+A+683+yYVl3Ap72iKTJRa0oAhUCAkAFnkPjCKTd9q/4RTwhIM76VimBMQICwBg1x4QScOc/vl1ZHwfYCRi/ZhwZR0AAiNMrlY4QSPrO9km/7c5OwIiF5xACAQQEgABNUuI4gbQX/5Pu5tTfcicEjFuDjiLQsoAA0HJ31DZawMV/NN25ByYNAff3Xf/aed+dML2yEQksJyAALGftTAsJeOY/H/TBtu/7N/p9eWG+szQ3shDQXEsUNIWAADCFojGaEXDxn78VWY3tBMy/tpxhWQEBYFlvZ5tRIOvd6W6GZ/4XtUkIuEjI/yfQvoAA0H6PVDhAwAVpANLEL0kauJ76ewoTExuOwKwCAsCsvAZfQiDpxb+JC1FSe+8JWOIP2zlmFxAAZid2gjkFXIDm1B02th4Mc/IqAq0JCACtdUQ9gwVceAZTzf7CpI8DRv3OwuzNcAICAwUEgIFQXtaWQNILThPb/uetBIGsrb8R1RC4SEAAuEjI/29OIOnFP8RzZyGguT8XBRE4V0AAsDhCCbjAtN8u38LYfo9USOAgIABYB2EEkt75N73tf97iyRgCul35uOu616f+HYYwf6AKDScgAIRrWc6Ck/4sbYhtfyHgSwLeGJjzn6iQsxYAQrYtV9FJL/4h7/yfXJlZH9ms8e2Muf5VMNspBASAKRSNMZtA0l+g28TF/7NFIQTM9udhYAJVAgJAFZ+D5xRIeucfetv/aY8DTrruJ9l+RdBOwJz/Qhi7VkAAqBV0/CwCSS/+m7rz9zjgVOD+bl+uX/reex/O8odiUAIVAgJABZ5D5xHIuu2/O+mub/0d5B4HzPM3Y1QCYwQEgDFqjplNIOmd/ya3/c9bJGlDgJ2A2f7dMPA4AQFgnJujZhBw5z8DaqNDngW9d0opzzVa4hxleRwwh6oxRwsIAKPpHDilQNI7/wcZtv3P3Qn4+csv7XflVinl+SnXUuNj+Z6AxhuUqTwBIFO3G51r0ou/C0EpJWnvH+z25Zo3Bjb6D1KisgSARM1ucappLwAJ3vA3dL2lfRxw0t3c+ps+h64Br1tHQABYx91Zf3/3l+05cOptf48DviRgLfiXcFUBAWBV/rwnT3vX553g5y76tLtBHgfk/Ydw5ZkLACs3IOPp0/5Db9v/wuWe9iOCHgdcuDa8YHoBAWB6UyM+ReDsH/jDO79zffzLP/CD/y6yfhx03/U3nrl67/3BUF5IoFJAAKgEdPhwARf/4VbZX2mXKPsKMP8lBASAJZSdo9jatQiOFcgaAuwEHLtSvH6sgAAwVs5xgwUy3vl3u/Jx13Wv+5jX4GXylS/0OKDOz9EEniYgAFgfswr85vaVb+367k3f9jYr86YHtxOw6faa3IoCAsCK+Fs/tYv/1ju83PzsBCxn7Ux5BASAPL1edKYZL/6n2/6/Kzd9xes8S00ImMfVqHkFBIC8vZ9t5hkv/qUUv/Q224r6/cBJQ0Cqn4teYBk5xZmAAGApTCqQ8eLvDX+TLqELBzu8qbTv+zf6fXnhwhdv5wUPfDpgO81sZSYCQCud2EAdGS/+p3f+vuRn8dWbNATYCVh8pW37hALAtvu72Oyy/oPs4r/YEvuDE2X9bol917/mGwPXW3dbOrMAsKVurjQX/xCvBO+0p18wlfBxgJ0Aa38SAQFgEsa8g7j45+19KzO3BlvphDqiCQgA0TrWUL3uvhpqRvJShIDkC8D0RwkIAKPYHOQfXGugNQFrsrWOqKd1AQGg9Q41WF/SO38fw2pwLT5ZUtZPonhjYIDF2WCJAkCDTWm5pKQXf2+6anlRPlFb1hDgEymBFmkjpQoAjTQiQhm2WCN0SY0HASHAOiBwsYAAcLGRV5RSHr5z5cVy0v3St69ZDlEEzkLA26WU56LUXFvn4Vspy+P+u5ev3fuodizHb19AANh+j6tn2P/s+qWHX//1P5VSvlM9WJwBbPvH6dW5lSbdCbhz+bff/PPu+7cebaCFpjCjgAAwI+5Whn54+8qNvu/e2sp8BszDxX8AUpSXZAwBXdffvHz13mH3w38EzhUQACyOCwU+ffflXyW6+/du/wtXRLwXJHwccGe3L3/jp6njrdUlKxYAltQOeq6Ht7/9r33fPxu0/GPKdud/jFaw12baCei67pNSyo8uX73742BtUu6CAgLAgthRT/Xpuy/3UWs/om4X/yOwor400ydZ+lJ++kevvvda1F6pe34BAWB+4/BnSBAAbPuHX6XDJ3AWAm5t/dMBXdf98+Wrd/90uIxXZhMQALJ1fMR8Nx4A7vsClRGLIkc9xNQAAArUSURBVPghGXYCBIDgi3SB8gWABZCjn2LDAeDB7qS7fumVux9E75H6jxd49POXX9rvyjsb3gm4841X3/uz42UckUVAAMjS6Yp5bjQAuPhXrImtHLrlxwHeA7CVVTrfPASA+Ww3M/IGPwXg4r+Z1Vk/kbOdgMN7Ap6vH62NEXwKoI0+tF6FANB6hxqob2PfA/Bgty/XfD66gYXVUAkbfBxwp+v7H/pK4IYWWYOlCAANNqW1kjb0TYDu/FtbXA3Vs6U3BvomwIYWVsOlCAANN6eV0g6/BfDp13/9j10pP2ilphF1eLf/CLRsh2zhcYBn/9lW7fj5CgDj7VIdefprgLvd233f/0nAid/f7ct12/4BO7dCyZFDwOGjf2W/v2Hrf4WFE/CUAkDApq1VctAQ4OK/1oIJfN6IIcDFP/CCW6l0AWAl+KinDRYCbPtHXWgN1H0IAf3Xylv9vrzQQDlPLaHblY/L4/677vxb71Rb9QkAbfUjRDWn/zCedP/Q+OMAF/8Qq6ntIiPsBBzu/LvH/V96xNX2WmqxOgGgxa4EqKnxnQAX/wBrKEqJLe8E2PaPsorarFMAaLMvIao6DQEn3S8b2yJ18Q+xemIV2WIIOGz7d78rN935x1pLLVUrALTUjYC1NLYT4OIfcA1FKbml7wlw5x9l1bRdpwDQdn9CVNdCCDi9G+q61/2wT4glE7bIFnYCXPzDLp/mChcAmmtJzIJWDgHu/GMum5BVrxkCXPxDLplmixYAmm1NvMJWCgEu/vGWSviKD48D+r5/Y8n3v3i3f/hl09wEBIDmWhK7oCVDwGHb/3Hf/8UzV++9H1tN9REFlgwB7vwjrpD2axYA2u9RuAoX+nSAO/9wK2N7BS/xxkBf8rO9ddPKjASAVjqxsTpm3gm4v+/619z5b2zRBJ3OnCHAtn/QRRGkbAEgSKMiljnTToCLf8TFsPGa53gc4M5/44umgekJAA00YcslTLwT8GDf9Tfc+W95xcSd25Q7Ae78466DSJULAJG6FbTWiUKAO/+g/c9U9hQhwJ1/phWz7lwFgHX905y9JgR4t3+aZbKJidY8DvBu/00sgTCTEADCtCp+oYcQsO+6v+1K+cERs7nT9f0P/czpEWJeurrAmLXel/LTXd//nbW+evvSFCAApGl1OxN9ePvKjb7v/qrrupf6vn/2ycq6rvuk7/sPu67/+0uP/vjd7vu3HrVTvUoIDBPof3b90qNL//KqtT7My6uWFxAAljd3xlLK2SOBV/Z9/293XfdvPkPZ9/3/3XXd/+ke9//Lr5xZKlsQOP3q4JPu35+31st+/wt3/VvodLw5CADxeqZiAgQIECBQLSAAVBMagAABAgQIxBMQAOL1TMUECBAgQKBaQACoJjQAAQIECBCIJyAAxOuZigkQIECAQLWAAFBNaAACBAgQIBBPQACI1zMVEyBAgACBagEBoJrQAAQIECBAIJ6AABCvZyomQIAAAQLVAgJANaEBCBAgQIBAPAEBIF7PVEyAAAECBKoFBIBqQgMQIECAAIF4AgJAvJ6pmAABAgQIVAsIANWEBiBAgAABAvEEBIB4PVMxAQIECBCoFhAAqgkNQIAAAQIE4gkIAPF6pmICBAgQIFAtIABUExqAAAECBAjEExAA4vVMxQQIECBAoFpAAKgmNAABAgQIEIgnIADE65mKCRAgQIBAtYAAUE1oAAIECBAgEE9AAIjXMxUTIECAAIFqAQGgmtAABAgQIEAgnoAAEK9nKiZAgAABAtUCAkA1oQEIECBAgEA8AQEgXs9UTIAAAQIEqgUEgGpCAxAgQIAAgXgCAkC8nqmYAAECBAhUCwgA1YQGIECAAAEC8QQEgHg9UzEBAgQIEKgWEACqCQ1AgAABAgTiCQgA8XqmYgIECBAgUC0gAFQTGoAAAQIECMQTEADi9UzFBAgQIECgWkAAqCY0AAECBAgQiCcgAMTrmYoJECBAgEC1gABQTWgAAgQIECAQT0AAiNczFRMgQIAAgWoBAaCa0AAECBAgQCCegAAQr2cqJkCAAAEC1QICQDWhAQgQIECAQDwBASBez1RMgAABAgSqBQSAakIDECBAgACBeAICQLyeqZgAAQIECFQLCADVhAYgQIAAAQLxBASAeD1TMQECBAgQqBYQAKoJDUCAAAECBOIJCADxeqZiAgQIECBQLSAAVBMagAABAgQIxBMQAOL1TMUECBAgQKBaQACoJjQAAQIECBCIJyAAxOuZigkQIECAQLWAAFBNaAACBAgQIBBPQACI1zMVEyBAgACBagEBoJrQAAQIECBAIJ6AABCvZyomQIAAAQLVAgJANaEBCBAgQIBAPAEBIF7PVEyAAAECBKoFBIBqQgMQIECAAIF4AgJAvJ6pmAABAgQIVAsIANWEBiBAgAABAvEEBIB4PVMxAQIECBCoFhAAqgkNQIAAAQIE4gkIAPF6pmICBAgQIFAtIABUExqAAAECBAjEExAA4vVMxQQIECBAoFpAAKgmNAABAgQIEIgnIADE65mKCRAgQIBAtYAAUE1oAAIECBAgEE9AAIjXMxUTIECAAIFqAQGgmtAABAgQIEAgnoAAEK9nKiZAgAABAtUCAkA1oQEIECBAgEA8AQEgXs9UTIAAAQIEqgUEgGpCAxAgQIAAgXgCAkC8nqmYAAECBAhUCwgA1YQGIECAAAEC8QQEgHg9UzEBAgQIEKgWEACqCQ1AgAABAgTiCQgA8XqmYgIECBAgUC0gAFQTGoAAAQIECMQTEADi9UzFBAgQIECgWkAAqCY0AAECBAgQiCcgAMTrmYoJECBAgEC1gABQTWgAAgQIECAQT0AAiNczFRMgQIAAgWoBAaCa0AAECBAgQCCegAAQr2cqJkCAAAEC1QICQDWhAQgQIECAQDwBASBez1RMgAABAgSqBQSAakIDECBAgACBeAICQLyeqZgAAQIECFQLCADVhAYgQIAAAQLxBASAeD1TMQECBAgQqBYQAKoJDUCAAAECBOIJCADxeqZiAgQIECBQLSAAVBMagAABAgQIxBMQAOL1TMUECBAgQKBaQACoJjQAAQIECBCIJyAAxOuZigkQIECAQLWAAFBNaAACBAgQIBBPQACI1zMVEyBAgACBagEBoJrQAAQIECBAIJ6AABCvZyomQIAAAQLVAgJANaEBCBAgQIBAPAEBIF7PVEyAAAECBKoFBIBqQgMQIECAAIF4AgJAvJ6pmAABAgQIVAsIANWEBiBAgAABAvEEBIB4PVMxAQIECBCoFhAAqgkNQIAAAQIE4gkIAPF6pmICBAgQIFAtIABUExqAAAECBAjEExAA4vVMxQQIECBAoFpAAKgmNAABAgQIEIgnIADE65mKCRAgQIBAtYAAUE1oAAIECBAgEE9AAIjXMxUTIECAAIFqAQGgmtAABAgQIEAgnoAAEK9nKiZAgAABAtUCAkA1oQEIECBAgEA8AQEgXs9UTIAAAQIEqgUEgGpCAxAgQIAAgXgCAkC8nqmYAAECBAhUCwgA1YQGIECAAAEC8QQEgHg9UzEBAgQIEKgWEACqCQ1AgAABAgTiCQgA8XqmYgIECBAgUC0gAFQTGoAAAQIECMQTEADi9UzFBAgQIECgWkAAqCY0AAECBAgQiCcgAMTrmYoJECBAgEC1gABQTWgAAgQIECAQT0AAiNczFRMgQIAAgWoBAaCa0AAECBAgQCCewP8H0J6i4qw2IYoAAAAASUVORK5CYII=');
}

/*
Ícone de Legenda.
 */
.jw-svg-icon-cc-off path {
	display: none;
}

.jw-svg-icon-cc-off {
	background-image: url('data:image/png;base64,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');
	background-size: contain;
	background-repeat: no-repeat;
}

.jw-icon-cc .jw-svg-icon-cc-off path {
	display: none;
}

.jw-icon-cc .jw-svg-icon-cc-off {
	background-image: url('data:image/png;base64,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');
	background-size: contain;
	background-repeat: no-repeat;
}

.jw-icon-cc:hover .jw-svg-icon-cc-off {
	background-image: url('data:image/png;base64,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');
}

.jw-icon-cc .jw-svg-icon-cc-on path {
	display: none;
}

.jw-icon-cc .jw-svg-icon-cc-on {
	background-image: url('data:image/png;base64,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');
	background-size: contain;
	background-repeat: no-repeat;
}

.jw-icon-cc:hover .jw-svg-icon-cc-on {
	background-image: url('data:image/png;base64,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');
}

/*
Ícone de Volume.
 */
.jw-svg-icon-volume-100 path {
	display: none;
}

.jw-svg-icon-volume-100 {
	background-image: url('data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAgAAAAIACAMAAADDpiTIAAAAY1BMVEVHcEz///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////80LMUcAAAAIHRSTlMAsqYQ/uwI+oDyFwMmC7wwHeaaSt45jdZoVMfOQV15crgIHTYAABNxSURBVHja7Z1bu6OoEkCJYoxRk5jE3C/+/195HuabM9M9e2+qiGmIrPUwb0N2W0uEAgpjAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAHyo2/6xna1m2WOXz3kcydGeVvuqtNaWVXd5LHkgiYX/2ZXDMFj713/KboECKfX+/cUOdviF/a7mwaQS/3s1fMGCkUAi8X8OX2IPGJAE38R/GIYHDyfp+Ntyx+OZfvzt8L0Bx5wHNPX4l8NP8BFIO/5DQReQdPyH4c5DmvL8zxn/YcVjmm78T4ObruVBTRVJ/IfqxoNKOf62ZBAw1fiXEgGG8smjSjn+tlzwrBKO/zAgwDTjXw0IQPwRgP4fAdKj1sQfAdJ+/xFgetxV8UeAxOOPAInHHwEmFv9qQADijwDEHwGIPwIQfwQg/giQCGe/+CNA4vFHgMTjjwCJxx8BJhH/YkAA4h9AgLzp+zXFhj45/i8I0B9Wx33Xdfvr9kypkU+Nv7cA50vx18KjtXao9hQd+9D4ewqwXv267GxtsW3oBj4w/l4C1Pdi+G/dEZv1HDT90+xejb+PAPXju6oz2Y16Ex8Wfw8B6p+qDmU7eoGPir+HALsfs042o/LYH4t/NwQQYHl0HDettijwOfFXC1AvBFVHDg3h+ZD4qwXYiJYdjg8qUX9G/NUCPITNXvgOfET8tQLUR2nDVcZ34APirxVgrTh4UjyZEr6J22jx1wqgO3m66hkKRB5/rQAHq2jb2pLLiSKPv1aATNe6HVbUIYw6/loBZuofqB6MBMaN/374KAGsnfVELdr4awXYWg8D9ifiFmv8tQIsrMdv2GrLMnGk8dcKsCu9fsVe1wQvyvhrBch9TyAUd1ICL9OPH3/1WkDm/UsHPgMRxl8twM3/p2YbYhhd/NUCzFf+v3VlPhhd/PU7gvrS/8c6bqfwj/9xiEOA+vDCr1VPhoJxxd9jU2g+e+XnuLA6rvj7nAvYrF75wYzJQEzx9zoZtHmlDxhWrBBHFH+/s4Ht4oWR4HBhOhhP/D0Ph9b9zL8oyXBkt6CG9Tvj718f4Jb570s4sjKgiP91iFIAY9ZbbzX3pIQiif9rJWI2C7+/zloMiCT+LxaJqr0VOGJAFPF/vUpYs9gzDvjc+I9RJm69KJgLfGr8R6kTWK+9dgkcyQeEj/9IhSLbnc/feiUnGDz+o1UKzZ8e34EV6wKh4z9iqdhmps8Pz1gb/PZxXoYPE6A2J/18YIsBYeM/brFofSdQUkokbPzHrhau7gQqdokFjf/o5eJ77W6RjpRgyPiPf1/AUrtXgIRQyPi/48KIs/IzMGMyGC7+b7kxpNF9BuyBgWCw+L/nyph8q/sbGAgGi/+b7gyqn6qBQMXKYKj4v+3SKF0h6yvDAK+vZ8QCKLeybhkGhIn/G6+NU/1jLFVkzKtHbmITQHV+xBYMA4LE/60XRy4VkwHL0nCQ+L/35tD8EMkfQvwDPfdWYUB1I/6TE8DMFQasNsR/cgJoDLAL4j89AUwuLzCe7kfgtQP3cQtgcnl52dmS+E9PALOUnxp4Jhn/ZcD4/5HZl/wDVzTEf4ICmEa8LpAR/ykKYNbiYhI74j9FARwXDv97YXhO/KcogDnZaYwD63Y+IvUmdPwdAsz70+KweJ5fz9HVwoUh28U6Dqzz8/bSFSMzRCzA/JwVVVmWZVlVx0fz4paNXDgVsNsowz9fbys72GFyfCtAez/+88+11lbb9WvXfzXC3eJRnhTZHMopRv8HAZrZf/7BNutfWrOXDgSz+LaH3Y7DVPlGgN3Xr+ts90IvUC+E2aDopoL3akhMgPM3gxNrty900NI647PIrpo8Tzj+XwvQ/5C3KRbew/RaOAyozlHFvy+GxARY/vzFO/rf+iC8fDyq04Lzy5CYAK47QWw5893C28oWBquYRgGPITUB1u7XdO+brxMuC0V0q8SyS04AyVtarjxHAifRgKqMZm/Q/FGmJsBSEiJru7PXSKCWzQSyWCYCm2mPAL4SQLpsUy68+ulG1KWWsRwUunfJCSBfn/K7CvQpajuWohHbKjUBanGBF+tX870WVcCsIjkkcLGpCbDUpD06n5TNTfRMH3EIsB9SE2CtEMDawudYt2SaYbs4hoEFAji6ao83tRF9V+PIB1cI4GrgoH+qkmVBe0GAIALk2k7PwwDRolAclaPSE0A/7PHYVyqZCsaxNyxBATKPNrST9kYyFdznCBBCgLt65mtL9QLxU/Aj1QkBQgiQ62c+Vl30XdQFzBAghADmoG/FqrfyShbZ9g0ChBBg45H8sFdlsDZHr78NAf6AAPXJpyFtmTdBP2NXLQIEEMC0XgfWlPc/SQ4MdzcECCGAV8lqWypzt4Lppn0gQBAB/IqWK8t73ARDjfAnBBIVoN7MPNbBV6qPQO0+LWrDnxNMVABj5g+PvVC6UbvkkMATAQIJYEyzVSugK/SXC1Ydgm8OTVgAY5qD9lDsRRUvwUxwv0aAcAIY0yx0CpSqYbvgBErwbSGJC2BMc1DlBXXZW8GCQOjdwckLYMxNkxayquoOgm0Blw0CBBbA5E/FU1Ad7d64vwGhT4gggDHG9Iq8kOZo91zQudwRILwAmtt/VBlhwbLTtkWA8AKYufwqUE3N98bd6nGJABEIoCmUo+gCJFWD1ggQhQC1+DLYlfydlWw9uCNAFAIorgNWFHjp3d+A7RwB4hBAbEAmD9nGmQuyxxYBIhFAOg5QzN0Fl4qVSwSIRQBhcQeryN+e3c3dECAaAYRF3wv5SyvYGvhAgGgEMLksJyg/07N07wsKWjwaAX5/Y0VPZDXmpoA9AkQkgOjooC2b8dqzZY4AEQmQi+pIyr/bN+cgoOwRICIBalEJEXl5D3clxvKEABEJILv3QV7eo3b2KPaAADEJMPK5ToFPKwSISgBROkgetLtzOWCPAHEJsHRv5rR7cS7IOQq0RYsAUQkguUNBfvOTu1hIsUaAuAQQXPsgH7m5zwhWuxoBohLACJYE5IMA5zSgPCFAZAK4szf2KN7Q70wGl4c5AsQlgHGvCXXiQYD7lHDAI6II8DWL0t1vi7cEuFKLIWsFIcA3i4LufLB4FNg7j4lfcwSITAD3uU47k47c3JnFY4MAsQmwda4Ki491uu+Q2d8QIDYBzs5BgPxCIeeIcn9GgNgEcN8uKM8FOo8HdScEiE0A57UCthQf6XFlgmzxRIDoBHBvDBK/ts5MULFAgOgEcC/ji1s+uMYT1QEBohPg7JwGiKPmLB1fbREgNgHq3imAeD+/80bxMkOA6HqAjVsA6RLOHQE+UIDW1W9bcaVntwAzBIhOgLlzNUBcLsp56NgiQIQCOLfySSuF1DunACsEiE8A5xreSroY4C48gQARCuBaw7OX0QQIeI8wArzQAyxHE4Ae4CMHgVIBnIPAEgEiFMD5aMabBTANjFCA5XhbOckDfKIAa1LBaQuwcwogXsFx1SG2CBChAO4ir+LVwAXLwR8ogPt0mHgbz8HVmVRsCIlPAOdOTnsfzaXigQCxCeBOA1RsCp2yAL3zycg38zvPh3d3BIhNAOc2ruEqPc5Tu88F7BAgNgHcFV7F+0Fy99GwNQJEJkDurvEsTgM0zmWlgPcGIYBn8m6w4pG7u9rEhePhsQngvuypEJ/nu7t3hCFAZAJs3De/y7/bD2e56C0lYiITwD0HGC7iwk7OPFD5QIC4BMjdcwD5GND9OanuVAmLS4C7+7FU4uTd0pkGqALWi0eAr9LAgisDOnFVl7VzPFFsECAqAQS3x9nriK11NQLEJEAruPDXyocA7trjV4MAMQlwFlwkLl8KFGwsyBAgJgEExeKHYS9O3bhnFPaBABEJUAtqxWu+AGvnUlB5RoCIBBBdHFjeRvyglA0CxCOA6OpQq7jr0d2hFHMEiEeAg6hV+S7e1p1TuBgEiEaAeylqVN5pCy4fOSBANAL0hajRmbzTvrmNuiNALAJIbgwchsEqtvAJrqBrECASATayu+M15f1zwc6SHAHiEGCzErapuOOpcX9TAm4HQoBf4j8TNrlX9Nk7d3OLGgFiEKCRvv/DQx6xVjCrvBkEiECA9VXaouZ+l6V7b2HIzQAI8E9X3Ylb1NT2vwmmlDkCBBdg/ijFDV4VHUAt+AKEHQIggDHGNLPBitvTdAC5+wtgdwYBwgqQ3ztFeyvNKS7BHKBrECCsALdM01ylemHdTdssR4CQAvQH3RNQ7d7KBW2fDAKEE6A/7FWNWV2HfXKPLKobAgQToN/uta3prncTLC1cNggQSIDldi8f+/89Z1ft3ekFxwsONQKEEeB21belHLFnbr+C7gdNWoBz4dGWLlqCI+bDpUGAIAKcS4+mDrrNmwvBb2wNAoQQoPd5/y+6Qj6tewiouH4YAcYUYLnyaKhTVvI6CR7tdYMAIQR4erRTKHP2khOmEXwBkhRg2Xk0o83YCY6YK/PKCDCWACePZpQDQJMLVhjstUWAEAJ4ZADUSzY7wYMtDwYBAgjQ6KeAK20lT0kHMBRrBAghwL18e/zNTvIbqxoBQghw0K4AXNTxX0qmABEkAdIUINPGXz9ZP0va3bcIEESA2bv7f2GNgRiGgAgw/vhfOs8smygE6PgE/Jyr8+inN5KVBjuLIv7mmJ4AC6v4n32qt2xFbd/iEGBWJieAfCm489qu0Yvav8zjEGBRJCfAUirAxStRU8uKDJzjiL/p98kJIB0FZn4X+TxEjV+XkQjQZukJIJqlVye/afpa9kadIom/qXdVcgJI9uqsPPP0tah7scfGRMMqOQHcmfrC+w6Xp2iAYZ/xxF+ye31qArQ/T9Sq1fq9Q6qoOgBjFskJ8HNB8Iv/97mVjS+Dlgf/4rOVJSfADwVh9gv/8XktfJfi6gBEteymJoBpvh4IdodX7m8SDqjLuDoAY0y+TU4As/ni31y8FH5pndF4cgD/MuBUpCaAaXe/zX+qxWtbtGphR1o+TYQ0hzIxAYxZ7rLqX0O/5sUdWtLBdCyrAL8xb56XsrQjE7UAxrTL22ObzbLFvXm5Uot0jak6m0ip6+Xt9FyMyWNmoxbgr392XY+wO3Mt3VkxMylRb23sAozDUnrYoFqbxAxIQgD5THphDAZMToBW/I/c5wYDpifAQjyFOpv0mG+nLsBJvJ6W1QYDJifAXRz/bm2SpN1OWYCdPIv6NIkSsA94uwCK+M+WqQpg2mD5gHcLcJPHv7gZgwETE0AR//hWgf/sVyCbogCK/j/03TDh8wHZ9ASQj/8H2/UmccKMBN8pwEmxn7Y8meQJMht8nwD1Q7OFIiP+YQx4mwCtagvNcUP4TZDNh+8SYKnaSVveCH4gA94kQHNR/RVPQh/KgPcIsFNVVrFZS+T//+nM7McLMH/qjtNdGQD8khGyHy7AUpnRKNZEPVxOcHwB+qvusqnqTMwD5gTHFiA/KU9TJ74EELwPGFmARv2nbxkABjVgXAFO6lLzqyXh/nIu8IkCNJn6/FxsJ8HTM2BEAU5H9VWjHROA0Bmh0QRYe9TULMgABzdgJAHyRaF+/W3JBDB8TnAUAdrz3uNvjeNGiNTHASMI0PazwSP+1bMmxuFngy8LUPfbwafQQUUCKAoDXhWgP/jVUSQBGIkBrwlwOxS+P0v/H8c44BUBzttu8BqoWkv8xfOrLFYB7jPv0mn2MSeykRjgK8D94l9DuTzx/kdjgJ8AzawavLMU5Z34Kw2wcQlQ7165R4UNIFH1AT4C3F+poN/tCGhMBngIsHulbu6xJ5xRzQb1AjSv3KW4Yv0/sj5ALcBLOxYz9v/EZoBagN0rv8X+P2/qNxmgFWDuf4lWwfLvSyyzGARYW4Z/kzJAKUDtfYVWxvAvynGAVoCr5888cuI3Rh9gAwuQ++WA9juyv5H2AUoB1j4355Qzuv9oDVAKsPMQoGPzT8QGKAU46wVYsfk/ZgPe3QMUB5J/URvw5jHAirW/yPMB2lmASoDqQfGX2A3QZgI1eYAVub/4DXhfJrA7kfv5AAPUawHSdrf0/h9hgFaAVlIB1JaXntTfZ8wF1PsBbu5hYHmk9PfHGKAWwF3R+si+jw8yQL8ncPPznsD9lsT/n6HOZ0EEMLcfCgF3B6Z+n9UH+JwL+LYUNOH/vLmA18mg/suvQLeg5tcfN2AWQgBjNv8dCe6fDTO/DzTA83Rwe/t1d/D1zqLfZxrgXR9gvl5cq7Isy7I6Hnomfp9qwEslYvJ+dz/fePcDzwVmwQSAz+8DECBxAxAgcQMQIHEDEGAS1N4GIMBE2MwQgK8AAmAAAmAAAmAAAmAAAmAAAmAAApAPQAAMQAAMQAAMQABGggiAAQiAAQiQgAErBEh8JCg0gCtc0/4K2JJaDmn3AVzilrgBBeUc0jbgyGNK24ADTylpA0pqOqRtwIpHlLQBJTV90jaAEUDaBlyo7ZC0AVdyAIkY8HVW+MoMIBWWhy/iz11uCTE/H+3v1zlQ2Csp2tOx+rvQu6323OSaIP1iddzv9/vLgYtcE/0QtMt1v162c+IPAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAP/E//Wybfk8B6fkAAAAASUVORK5CYII=');
	background-size: contain;
	background-repeat: no-repeat;
}

.jw-icon-volume:hover .jw-svg-icon-volume-100 {
	background-image: url('data:image/png;base64,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');
}

.jw-svg-icon-volume-50 path {
	display: none;
}

.jw-svg-icon-volume-50 {
	background-image: url('data:image/png;base64,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');
	background-size: contain;
	background-repeat: no-repeat;
}

.jw-icon-volume:hover .jw-svg-icon-volume-50 {
	background-image: url('data:image/png;base64,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');
}

.jw-svg-icon-volume-0 path {
	display: none;
}

.jw-svg-icon-volume-0 {
	background-image: url('data:image/png;base64,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');
	background-size: contain;
	background-repeat: no-repeat;
}

.jw-icon-volume:hover .jw-svg-icon-volume-0 {
	background-image: url('data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAgAAAAIACAYAAAD0eNT6AAAgAElEQVR4Xu3dbahl13kf8LXv1UgzkUbEiTxCNbZCUEibD3FBddxSbI2oa9NE2L6WIkGaihJXBBu/YbCwoaWEYqo6iRRXDo5RlPaDmw/G0igGGyIc9EYxqZtQ91NBoS8CIxpMWxJszZ3RPbucOy+al3vn7H3O2ns/e62fvonZZ+21fs9z7vqfvfc9t0n+I0CAAAECBKoTaKpbsQUTIECAAAECSQDQBAQIECBAoEIBAaDColsyAQIECBAQAPQAAQIECBCoUEAAqLDolkyAAAECBAQAPUCAAAECBCoUEAAqLLolEyBAgAABAUAPECBAgACBCgUEgAqLbskECBAgQEAA0AMECBAgQKBCAQGgwqJbMgECBAgQEAD0AAECBAgQqFBAAKiw6JZMgAABAgQEAD1AgAABAgQqFBAAKiy6JRMgQIAAAQFADxAgQIAAgQoFBIAKi27JBAgQIEBAANADBAgQIECgQgEBoMKiWzIBAgQIEBAA9AABAgQIEKhQQACosOiWTIAAAQIEBAA9QIAAAQIEKhQQACosuiUTIECAAAEBQA8QIECAAIEKBQSACotuyQQIECBAQADQAwQIECBAoEIBAaDColsyAQIECBAQAPQAAQIECBCoUEAAqLDolkyAAAECBAQAPUCAAAECBCoUEAAqLLolEyBAgAABAUAPECBAgACBCgUEgAqLbskECBAgQEAA0AMECBAgQKBCAQGgwqJbMgECBAgQEAD0AAECBAgQqFBAAKiw6JZMgAABAgQEAD1AgAABAgQqFBAAKiy6JRMgQIAAAQFADxAgQIAAgQoFBIAKi27JBAgQIEBAANADBAgQIECgQgEBoMKiWzIBAgQIEBAA9AABAgQIEKhQQACosOiWTIAAAQIEBAA9QIAAAQIEKhQQACosuiUTIECAAAEBQA8QIECAAIEKBQSACotuyQQIECBAQADQAwQIECBAoEIBAaDColsyAQIECBAQAPQAAQIECBCoUEAAqLDolkyAAAECBAQAPUCAAAECBCoUEAAqLLolEyBAgAABAUAPECBAgACBCgUEgAqLbskECBAgQEAA0AMECBAgQKBCAQGgwqJbMgECBAgQEAD0AAECBAgQqFBAAKiw6JZMgAABAgQEAD1AgAABAgQqFBAAKiy6JRMgQIAAAQFADxAgQIAAgQoFBIAKi27JBAgQIEBAANADBAgQIECgQgEBoMKiWzIBAgQIEBAA9AABAgQIEKhQQACosOiWTIAAAQIEBAA9QIAAAQIEKhQQACosuiUTIECAAAEBQA8QIECAAIEKBQSACotuyQQIECBAQADQAwQIECBAoEIBAaDColsyAQIECBAQAPQAAQIECBCoUEAAqLDolkyAAAECBAQAPUCAAAECBCoUEAAqLLolEyBAgAABAUAPECBAgACBCgUEgAqLbskECBAgQEAA0AMECBAgQKBCAQGgwqJbMgECBAgQEAD0AAECBAgQqFBAAKiw6JZMgAABAgQEAD1AoDCBHz71rtuONNedSE37d1LT/vyiTX8zpfTTlyzzv2816b+ltvmvqW3+85GjP/ofzS/+6V8VxmA5BAisEBAAtAiBQgTab73z5t3Tx96dmvTBlNoPpJRu6bC0H6TU/FGb0leP3vDanwsCHcQcQqAQAQGgkEJaRt0CZ56+++1pa/Frizb9SseN/0qwH2w16Q/TYusPrv/Qc9+rW9PqCdQhIADUUWerLFhg95m7dto2fSGldEeGZf5F06SHb/jgC6cyjGUIAgQCCwgAgYtjagRWCZw5dfLDi7b9jdSkt6w6tvO/t+n7W03zL6/fef7Jzq9xIAECsxMQAGZXMhMmcE5gf/NP7SNrXvJfxfi/mrT18A07z31t1YH+nQCBeQoIAPOsm1lXLjDIJ/8rTJvUfLdpm4c8E1B5s1l+sQICQLGltbBSBcbY/C/YtSl97djOCw+UamldBGoWEABqrr61z05g4Mv+V3u06ftNs/VptwJm1yomTGClgACwksgBBGIIjPnJ/4oVP3N054WdGApmQYBALgEBIJekcQgMKDDh5r9c1V+0qXno2M7zzw+4REMTIDCygAAwMrjTEegrMPHmv5zu2ZSazx3def63+87d8QQIxBUQAOLWxswIpN1TJ3+1bdtHsv6e/1quzZNHd57/Z2u91IsIEAgpIACELItJEUiBNv/9ajy7t1j80xvvfelVtSFAoAwBAaCMOlpFYQJxPvlfhH027bUfO3rfiy8XRm05BKoVEACqLb2FRxUIuPknXwoUtVvMi8D6AgLA+nZeSSC7QMTNf7lIASB7qQ1IYHIBAWDyEpgAgXMCUTd/AUCHEihTQAAos65WNTOByJu/ADCzZjJdAh0FBICOUA4jMJRA9M1fABiq8sYlMK2AADCtv7NXLrB76u7723bx6PS/53/tQngGoPJGtfwiBQSAIstqUXMQ2N/80+ILKaXbo89XAIheIfMj0F9AAOhv5hUENhaY0+bvFsDG5TYAgZACAkDIsphUyQJz2/wFgJK70dpqFhAAaq6+tY8uMJd7/lfCuAUweqs4IYHBBQSAwYmdgMA5gd1n7tpp2/TYHO75CwC6lkD5AgJA+TW2wgAC+5v/Ij0e/Wn/w6hcAQjQRKZAILOAAJAZ1HAErhSY8yf/C2sRAPQ1gfIEBIDyampFgQTm/slfAAjUTKZCILOAAJAZ1HAELgicfvrkPalpvzTHe/6eAdDHBMoXEADKr7EVTiBQ0ua/5HMLYIImckoCAwsIAAMDG74+gdI2fwGgvh624joEBIA66myVIwmUuPkLACM1j9MQGFlAABgZ3OnKFSh18xcAyu1ZK6tbQACou/5Wn0ng/Oa//JKfOzINGWoYzwCEKofJEMgiIABkYTRIzQKvnTp5skntE6Vu/q4A1Nzd1l6ygABQcnWtbXCBGjZ/AWDwNnICApMICACTsDtpCQK1bP4CQAndag0ErhYQAHQFgTUEatr8BYA1GsRLCMxAQACYQZFMMZZAbZu/ABCr/8yGQC4BASCXpHGqEKhx8xcAqmhti6xQQACosOiWvJ5ArZu/ALBev3gVgegCAkD0CplfCIGaN38BIEQLmgSB7AICQHZSA5YmUPvmLwCU1tHWQ+CcgACgEwhcQ8Dmf+EHRfPdpm0euv5Dz31PwxAgUIaAAFBGHa1iAAGb/xuovgp4gAYzJIGJBQSAiQvg9DEFbP6X10UAiNmnZkVgEwEBYBM9ry1OoP3KnUfOvvnmn1s0i6+X/N3+fQsnAPQVczyB+AICQPwameGIAmeevvvtbdM+0ab2HSOeNvypBIDwJTJBAr0FBIDeZF5QqoDN//DKCgCldr111SwgANRcfWu/KGDzv3YzCADeLATKExAAyqupFfUQuHDP32V/AaBH2ziUQBECAkARZbSIdQV88u8m5wpANydHEZiTgAAwp2qZazYBn/z7UQoA/bwcTWAOAgLAHKpkjtkFfPLvRyoA9PNyNIE5CAgAc6iSOWYVsPn35xQA+pt5BYHoAgJA9AqZX1YBm/96nALAem5eRSCygAAQuTrmllXA5r8+pwCwvp1XEogqIABErYx5ZRWw+W/GKQBs5ufVBCIKCAARq2JOWQVs/ptzCgCbGxqBQDQBASBaRcwnq4DNPw+nAJDH0SgEIgkIAJGqYS5ZBWz++TgFgHyWRiIQRUAAiFIJ88gqYPPPypkEgLyeRiMQQUAAiFAFc8gqcPrr7/6ZZnvrP/iTvvlYBYB8lkYiEEVAAIhSCfPIImDzz8J41SACwDCuRiUwpYAAMKW+c2cVsPln5bxsMAFgOFsjE5hKQACYSt55swrY/LNyugIwLKfRCYQQEABClMEkNhFYbv5pu/lSSum9m4zjtYcLuAKgOwiUJyAAlFfTqlZk8x+n3ALAOM7OQmBMAQFgTG3nyirgsn9WzmsOJgCMZ+1MBMYSEADGknaerAI2/6ycKwcTAFYSOYDA7AQEgNmVrO4Jt1+588juT974U+75j9sHAsC43s5GYAwBAWAMZefIJuCefzbKXgMJAL24HExgFgICwCzKZJJLAZv/dH0gAExn78wEhhIQAIaSNW5WAZt/Vs7egwkAvcm8gEB4AQEgfIlM0OY/fQ8IANPXwAwI5BYQAHKLGi+rwGvfeM/bmr2zT/iSn6ysvQcTAHqTeQGB8AICQPgS1TtBm3+c2gsAcWphJgRyCQgAuSSNk1XAZf+snBsPJgBsTGgAAuEEBIBwJTEhm3+8HhAA4tXEjAhsKiAAbCro9VkFbP5ZObMNNlQAWH6x05kTN++0qX1v2lv8m6P3vfhytkkbqHgB/bNZiQWAzfy8OqOAzT8jZuahhggA5354H3+gTe1jKaVbUkrP7C0WH73x3pdezTx9wxUosN8/t950T7tIj6cmvSWl9Gzaaz8mRHYvtgDQ3cqRAwp44G9A3AxD5w4AB2z+y1mebZrmG6/v7X1cCMhQtIKHOGDz3++flNJzQkD3wgsA3a0cOZCAzX8g2IzD5gwAh2z+F2YrBGSsW4lDXbzs3y4ePf/J/9JlCgE9ii4A9MByaH4Bm39+0yFGzBUAVmz+F0NASumb7faRTx57/7dfGWI9xpynwIrN/9L+cSWgQ4kFgA5IDhlG4Pzm/8WU0geHOYNRcwnkCAAdN38hIFfRChun4+Z/WQhot488JEQe3ggCQGFvkrksZ7n5by1ef7Rt23vnMuea57lpAOi5+bsdUHOzHbD2Q+75r1JyO2CFkACwqoX8e3YBm3920sEH3CQArLn5CwGDV3UeJ1hz83c7oEN5BYAOSA7JJ+Cyfz7LMUdaNwBsuPlfFgIWW9d92uXcMas+/bl6XvY/bML7VwLcDriaRwCYvsermYHNf76lXicAZNr8hYD5ts1GM8+0+bsScI0qCAAbtagXdxVw2b+rVMzj+gaAzJv/pT/Ev+nLgmL2SM5ZZd78hYBDiiMA5OxaYx0o8MOn3nXb1tbW7zQp3Y9ongJ9AsDyh/fZE8cfXKT2kfPf8Jdz0b4nIKdmwLE2vOe/akUeDLxESABY1S7+fSMBm/9GfGFe3DUADPTJ/0qH/RDgmYAw7ZFtIm98t//iCyml27MNfPVAvjY4pSQADNhhtQ+9vOyf9s7+pk/+8++ELgHg4ubfto8c8A1tuRGEgNyiE4830GX/w1blSoAAMHHHF3x6m39ZxV0VAEbe/C+9p+sbAwtotZE3/0vFqr4S4ApAAW+eaEtw2T9aRTafz7UCwEiX/a/1SU4I2LzEk40w4eZ/Yc3VhgABYLK2L/PENv8y63pYAGi/9c6bz+4e++WBHvjriul2QFepYMeNeM9/1cqf3Wq3Hr7+Q899b9WBJf27AFBSNSdei8v+ExdgwNMfFAAuedr/yymlIwOevsvQQkAXpUDHBPjkf5nGssdv2Hn+FwIRDT4VAeAQ4v0fbm+++efarcVPN23zE4uUfnzwasz8BE2T/p7v9p95EQ+Z/mEB4MyJ4w+0qX1sgF/3Wwdy+WCX2wHryI38mmib//nlP3t054X3jUwx6ekEgCv4l5ewr9va/gdtSieblH6+bdu/kZp0IsAnnEkbxcnrFjj0FsBX7jxy5sTNO20a/Ne2+hTgGX9KuA/XuMcG3fyfSXvtw0fve/HlcTWmPZsAcN7/knuZ96SUfsmGP21jOnssgdUPAcYKAU3TPOV7AmL10HI2ETf/mntFAEgpnXn67rcvmvbjKbUfCHIpM94714yqFuj0a4C33nRP26bl7YAhv8Clcx1q/sHeGWnEAwM98Hdx1bX3SPUB4LVTJ082qf1cSulun/pH/GngVLMSWBUALn66EwJmVdexJhtx829T+lraPvKZmv/CZLUB4OJDfk37RJvad4z1RnAeAnMU6BIALrvEG+yZgBrv70bps4CX/f3GyPnmqDYALB/2297a+vcppfdGeaOYB4GoAl0DQOQQ4MHA8bvL5j++eZ8zVhsATp86+fsptQ+67N+nXRxbq0CfABA1BNR+v3fs3rX5jy3e/3xVBoDTT5+8JzXtv/PAX/+G8Yo6BfoGACGgzj65sOqA9/zPtimdqv2e/5VdWWcAOHXXH3vor+4fUFbfT2CdAHAxBAR7MDClVOXvfPer+PpHR938F4vFp26896VX119Zea+sLgDsP/Xftl8d4c+VltctVlStwLoB4LIrAe3i0UDvOyFggG6OuPk3TfON1/f2Pm7zv7rgVQWAZXPunjj+iZTaf+3e/wDvfkMWK7BJABACim2LyxYWdfP3hVCH919VAWDJcPrUXad8018dP5CsMp/ApgHAMwH5ahFxpKibv0/+1+6W6gLA7qmT/8nv/Uf8EWJOkQVyBICozwQsfzugfX3xudq+Bz5Xv12y+X8+pXRHrnE3GGf/gT/3/FcLVhcATp+6639G+arS1eVxBIEYArkCwGUhYJEe90xAjPquOwuf/NeVi/E6ASBGHcyCQGiBnAEg6pUAvx3QrwWjbv7u+XevowDQ3cqRBKoVyB0Aol4JcDugW4vb/Ls5RT9KAIheIfMjEEBgiAAQ9UqAEHDthou4+bvnv94PCQFgPTevIlCVwFABIGoIcDvg4Pa2+Zf1thcAyqqn1RAYRGDIABD1doAQcHkrRdz8fcnPZm93AWAzP68mUIXA0AHgYgg4cfNO6xsDQ/bU7qm772/j/Jnn/T/p6/f8N2sVAWAzP68mUIXAGAEg6pUAzwSkZPMv820uAJRZV6sikFVgrAAQ9ZmAmkPA+c3fl/xkfUfFGEwAiFEHsyAQWmDMABD1SkCNzwTY/EO/LTeenACwMaEBCJQvMHYAEAKm7ymX/aevwdAzEACGFjY+gQIEpggAQsB0jWPzn85+zDMLAGNqOxeBmQpMFQCihoCSnwmIdtnf0/7D/dAQAIazNTKBYgSmDABRQ0CJzwRE2/x9w9+wP0IEgGF9jU6gCIGpA8CFELD75uPvS6n9PX9FMH9bRbvsb/PPX+MrRxQAhjd2BgKzF4gQAFwJGK6Nom3+LvsPV+tLRxYAxnF2FgKzFogSAKKGgDk/E2Dzn/Vbc6PJCwAb8XkxgToEIgWAy0JAmx5LKd0eoQpzDAHu+UfonOnmIABMZ+/MBGYjEC0AeCZg89ax+W9uOPcRBIC5V9D8CYwgEDEAXBYCmvZLUa4EzOG3A6Jd9vfA3whv4gNOIQBM4+6sBGYlEDUARH0mIHIIiLb5e+Bvuh8FAsB09s5MYDYCkQNA1BAQ8ZkAm/9s3nKjTFQAGIXZSQjMWyB6ALgsBHgw8MBmc89/3u/BIWYvAAyhakwChQnMIQBcID/99Ml7fFnQ5Q1o8y/sDZlpOQJAJkjDEChZYE4BYFmH3Wfu2mkX6XHfGJhStM3fPf84PykEgDi1MBMCYQXmFgCEgHOtFPGe/2Lruk8fe/+3Xwnb7BVNTACoqNiWSmBdgTkGgIshoNJnAqJ98verfuu++4Z7nQAwnK2RCRQjMNcAsCzA/jMBlX1PgM2/mLfeoAsRAAblNTiBMgTmHAAuhoBK/opgtMv+PvnH/RkgAMStjZkRCCMw9wBQy5WAaJu/B/7CvIUPnIgAELs+ZkcghEAJAaD0EBBx8/fAX4i376GTEABi18fsCIQQKCUAlBoC3PMP8TaZ3SQEgNmVzIQJjC9QUgAoLQRE++Tvnv/47891zygArCvndQQqEigtAJQSAoJt/qlN6WuLxeJTN9770qsVvT1mu1QBYLalM3EC4wmUGAAuhoCZ/nZAxM0/bR/5jC/5Ge99uemZBIBNBb2eQAUCpQaAuV4JsPlX8KYbYYkCwAjITkFg7gIlB4C5hYCIm7/L/vN8hwsA86ybWRMYVaD0ADCXELD/R44CfbWxe/6jvg2zn0wAyE5qQALlCdQQAKKHAJt/ee+rqVckAExdAecnMAOBWgLAshTx/pRw8+RWSt9ZpPazKaU7IrRL0zRP+ZKfCJXYbA4CwGZ+Xk2gCoGaAkDQKwFh+mx52d/T/mHKsdFEBICN+LyYQB0CtQUAIeDgvnbPv6z3uwBQVj2thsAgAjUGACHg8lay+Q/y1pp0UAFgUn4nJzAPgVoDgBBwrj9d9p/H+7TvLAWAvmKOJ1ChQM0BYFnuaE/gj9mCHvgbU3vccwkA43o7G4FZCtQeAGq9EuCT/yzfrp0nLQB0pnIggXoFBIBztT/99Ml7UtN+KaV0e+nd4J5/6RVOSQAov8ZWSGBjAQHgDcIaQoBP/hu/ZWYxgAAwizKZJIFpBQSAy/1LDgHu+U/7Xhvz7ALAmNrORWCmAgLA1YUrMQTY/Gf6Bl1z2gLAmnBeRqAmAQHg4GqXFAJc9q/pHX1urQJAfTW3YgK9BQSAw8lKCAE2/95viSJeIAAUUUaLIDCsgABwbd94f0Coez/Y/LtblXakAFBaRa2HwAACAsBq1P0rAan9vdSkt6w+OsYR7vnHqMNUsxAAppJ3XgIzEhAAuhVrTrcDbP7dalryUQJAydW1NgKZBASA7pBzCAEu+3evZ8lHCgAlV9faCGQSEAD6QUYOATb/frUs+WgBoOTqWhuBTAICQH/I106dPNmk9omU0h39Xz3UK5on9xZ7/+LGe196dagzGHc+AgLAfGplpgQmExAA+tOfvwrwWKQA4Pv9+9ex5FcIACVX19oIZBIQAPpBRv61QA//9atlyUcLACVX19oIZBIQALpDzuHXAYWA7vUs+UgBoOTqWhuBTAICQDfIyJ/8D1jBM+32kU8ee/+3X+m2OkeVJiAAlFZR6yEwgIAAsBp1Zpv/hQUJAatLW+wRAkCxpbUwAvkEBIBrW850899flNsB+d4ncxtJAJhbxcyXwAQCAsDh6HO457+qZYSAVUJl/rsAUGZdrYpAVgEB4GDOyF/407cBhIC+YvM/XgCYfw2tgMDgAgLA1cQlfPI/oHE8EzD4uynOCQSAOLUwEwJhBQSAy0sz53v+HZpMCOiAVMIhAkAJVbQGAgMLCABvABf6yf+yDnI7YOA3VJDhBYAghTANApEFBIBz1Snpnv+qfvNHg1YJzf/fBYD519AKCAwuIADUtflfaChXAgZ/a016AgFgUn4nJzAPgdoDwP49/zYt/7DP7fOoWNZZeiYgK2ecwQSAOLUwEwJhBWoOAIU/8Nep51wJ6MQ0u4MEgNmVzIQJjC9QawCo6Z7/qq7yTMAqofn9uwAwv5qZMYHRBWoMADb/q9tMCBj9rTfoCQWAQXkNTqAMgdoCQOX3/K/ZtG4HlPGeXq5CACinllZCYDCBmgJAvHv+zZNbKX1nkdrPppTuGKzI/Qb2YGA/r5BHCwAhy2JSBGIJ1BIA4m3+6Zm01z589L4XX452VcKVgFjv0XVmIwCso+Y1BCoTqCEARLvnv9xg29cXn1tu/hfaLVoIWD4TsFgsPnXjvS+9WtlboojlCgBFlNEiCAwrUHoAiPbJ/6DN/4oQ8IUotwNcCRj2vTfk6ALAkLrGJlCIQMkBINp3+19r8496JSCl5JmAGb7XBYAZFs2UCYwtUGoAiPbJf7mRXrjnv6rGu6fuvr9Ni+WVgBDfTuhKwKqKxft3ASBeTcyIQDiBEgNAtE/+fTb/i1cCzoWAz0e6HfD63t7HPRMQ7i184IQEgHnUySwJTCpQWgCItvl3uex/WAOcvxIQJgR4MHDSt2qvkwsAvbgcTKBOgZICQLTL/ssNs9lr//mlT/v37bLzvx0Q6sFAVwL6VnH84wWA8c2dkcDsBEoJACV98r+yiaJdCfBMQPy3uQAQv0ZmSGBygRICQLRP/uvc81/VCMEeDDzbNM03XAlYVbXp/l0AmM7emQnMRmDuAaDkT/7BrwScbVM65cuCYr7VBYCYdTErAqEE5hwAatr8LzRNsGcChIBQ7+Y3JiMABC2MaRGIJDDXABDtsv8mT/v37YdoIWB5O2Cxdd2nj73/26/0XYvjhxEQAIZxNSqBogTmGABq3vwvXgmI9T0BZ1NK32y3j3xSCIjx40EAiFEHsyAQWmBuASDa5j/EA39dGybYbwd4MLBr4UY4TgAYAdkpCMxdYE4BINrmP+Zl/8P6LFoI8GBgjJ8IAkCMOpgFgdACcwgA7VfuPHLm1pvuaRfp8dSkt0QAzfElP7nWEfGZAL8imKu6640jAKzn5lUEqhKIHgBs/t3aMdqVAA8GdqvbUEcJAEPJGpdAQQKRA0DEzX/Ke/6r2k4IWCVUz78LAPXU2koJrC0QNQDY/NcracQQ4HbAerXc5FUCwCZ6XkugEoGIASDi5h/hgb+uLRktBHgwsGvl8h0nAOSzNBKBYgWiBYCIm3+kB/66NmK0EOBvB3StXJ7jBIA8jkYhULRApAAQcfOf0yf/Kxs1WgjwZUHj/SgRAMazdiYCsxWIEgAibv6RH/jr2nARQ8DeYvHRG+996dWua3BcfwEBoL+ZVxCoTiBCALD5D9t20UKAZwKGrfdydAFgeGNnIDB7gakDQMTNf86X/Q9ryGghwDMBw/7oEACG9TU6gSIEpgwANv9xW0gIGNd7yrMJAFPqOzeBmQhMFQD2N/8TN++07eLRKF/vW8I9/1VtFzEE+FPCq6rW/98FgP5mXkGgOoEpAoDNf9o2ixgCfFlQ3p4QAPJ6Go1AkQJjB4CIl/1r+OR/ZfNGCwEeDMz740UAyOtpNAJFCowZACJu/nP8kp9cjRgtBHgwMFdl/RZAPkkjEShYYKwAEHHzL/Fp/76tGi0E+LKgvhU8+HhXAPI4GoVA0QJjBICI9/xt/m+09fkQ8IWU0u0Bmv2sELB5FQSAzQ2NQKB4gaEDQMTNv8Z7/qsaOVoIcDtgVcWu/e8CwGZ+Xk2gCoEhA4DL/vNpoYtBLS0+n1K6I8DMzwoB61dBAFjfzisJVCMwVAC4uPm36bEgl5ZTzQ/8dWnoqCHA9wR0qd7lxwgA/c28gkB1AkMEgIiX/Zf3/G0k3do72u0AzwR0q9ulRwkA/c28gkB1ArkDQMTN3z3/fm19yZUADwb2owtzdI0B4HYyXCgAABJ/SURBVOUg967CNIGJEFglkDMA2PxXac/n3yOGAM8EdO+fGgPAH6eU3tudyJEECOQKABE3f7/qt1l/R30mwNcGr65rhQHg5O+n1D6YUjqymscRBAgsBXIEgIib//KBv7R95DPH3v/tV1R6fYFLHuZc3g7w2wHrU476yuoCwJlTJz+8SO0jKaVbRpV2MgIzFtg0AETc/D3wl7cho94O8FDn4XWuLgC89o33vK3ZO/snQVJq3neg0QgMJLBJAIi4+Xvgb5hGiRgC/HaAAHCZwJln7vriok0fcRtgmB8CRi1PYN0AEHHzd89/2P6M+kyAKwFX1726KwBLguVVgK2917/epvYdw74VjE6gDIF1AkDAT4PJZf9x+jHqMwFCwOX1rzIALAnOf4nF73oWYJwfCM4yb4G+ASDiJ38P/I3bgwG/5XH/a4OFgDf6oNoAsGzO3RPHP5FS+1khYNwfDM42P4E+ASDi5r+8599uH/mkp/3H7b2AV4H8FcFLWqDaALA0WDbn2Vtv+i3PA4z7Q8HZ5ifQNQBE3Pxd9p+234SAaf2vdfaqA8CFEHD+SsDHo/wxkrjtYma1CnQJAAF/0O//YR+/5z9910bsDcFw+f0e/tu/EnDm1pvuadu0/IKgX/LbAZqCwJUPCzXfbdrmoes/9Nz3DrKJ+APe5h+riwM+E1D9Q6ECwCXvkeVvB2zvvf4P2yb9o3bR/t3UpLfEeguZDYFpBK51BSDi5u/T3TR9suqsEXul5u+EEAAO6NgfPvWu27ab7TtTk342pfS3Umrf2qTmTauau/Z/92uV5XbAYQEg4A90T3oHb8OAPbMUeybttQ8fve/F5R+Lq+Y/AeAapV426vKfT9/2ptu2X98TAK5htde0b9pu2p1Fmz5RzbunooUeFADO/SA//kCb2seC/CaNzX8mPRk0BDx7dOeF982EMMs0BYA1GZcN3Pz6ny1/pWT/v9r/f9/gW++8+eyZo/9KCFizqQK/7LAAcPbE8QcXqf1ygOdmbP6B++egqUULAcsev2Hn+V+YGeNG0xUANuLz4isFhIAye+LQWwDL0Ld77JcXbfsbEz4zc7ZN6dRisfjUjfe+9GqZFShzVYEeDHx2q916+LCHXMvU91sApdZ10nUJAZPyD3Ly1Q8BHn+gbdtHJggB+5/8/e33Qco+yqABQsCzaa/9WG33/5fFdQVglBav7yRCQFk1X/U9ABefBxg3BLjsX0ibTXQ7YHkL97laN38BoJA3T9RlCAFRK9N/XqsCwIXnYPYfChwnBNj8+5cx9CsmuBLwbLt95KGavx7aFYDQb4n5T04ImH8Nz31SuPYXAV1Y5Ui/GeCefxltddUqRgwBVf7a35XgAkChb6RIyxICIlVjvbl0DQCXXQkY5tcDbf7rlXA2rxo4BFR/2f/SRhAAZvO2mPdEhYB5169PABgwBHjgb95t1Hn2F0PAIj2e8cFSm/8VFRAAOrekAzcVEAI2FZzu9X0DwAAhwD3/6co/yZkz/2XJ/c2/9nv+bgFM0spOevEe8bfeefPu7rFHU2o/TGU+AusEgMtCwGYPBvrkP59WyTrTTLcDbP6HVMUVgKztarAuAq4EdFGKdcy6ASDDlQD3/GO1wuiz2fB2gM3/GhUTAEZvZyfc3xR8bfCsGmGTALBBCLD5z6pLhpvsmiHAPf8VJREAhutZI68QEALm0yKbBoA1QoDL/vNpj1Fm2jME+OTfoSoCQAckhwwnsAwBngkYzjfXyDkCQI8Q4IG/XIUrbJyOIcDm37HuAkBHKIcNJyAEDGeba+RcAaBDCPDJP1fRCh1nxYOBNv8edRcAemA5dDiB5Zt698TxL6fUPhjgT8sOt9CZjpwzAFwjBLjnP9P+GHvah1wJcM+/ZyEEgJ5gDh9O4JJnAj4iBAznvM7IuQPAGyHg5p02LX43pXRL0zRP+at+61SnztccEAKq/27/vp0gAPQVc/ygApfcDnAlYFDpfoMPFQCWszh74viDi9TeX/NfZetXDUdfELjkb0/8E/3Tvy8EgP5mXjGwgBAwMPAaww8RAC79Ib77kzf+VI1/j32NUnjJFQL7tw/1z1p9IQCsxeZFQwt4JmBo4X7jDxkA+s3E0QQI5BIQAHJJGie7wDIEnL31pt9atMkzAdl1+w0oAPTzcjSBOQgIAHOoUsVzdCUgRvEFgBh1MAsCOQUEgJyaxhpEQAgYhLXXoAJALy4HE5iFgAAwizKZpBAwbQ8IANP6OzuBIQQEgCFUjTmIgBAwCGunQQWATkwOIjArAQFgVuUyWQ8GTtMDAsA07s5KYEgBAWBIXWMPIuBKwCCs1xxUABjf3BkJDC0gAAwtbPxBBISAQVgPHVQAGNfb2QiMISAAjKHsHIMICAGDsB44qAAwnrUzERhLQAAYS9p5BhEQAgZhvWpQAWAcZ2chMKaAADCmtnMNIiAEDMJ62aACwPDGzkBgbAEBYGxx5xtEQAgYhPXioALAsL5GJzCFgAAwhbpzDiIgBAzCuj+oADCcrZEJTCUgAEwl77yDCAgBg7AKAMOwGpXApAICwKT8Tj6EgBCQX9UVgPymRiQwtYAAMHUFnH8QASEgL6sAkNfTaAQiCAgAEapgDoMICAH5WAWAfJZGIhBFQACIUgnzyC6wDADLQXdPHP9ySu2DKaX9//dffwEBoL+ZVxCILiAARK+Q+W0s4ErAxoQeAtyc0AgEwgkIAOFKYkJDCAgBm6m6ArCZn1cTiCggAESsijkNIiAErM8qAKxv55UEogoIAFErY16DCAgB67EKAOu5eRWByAICQOTqmNsgAssQcPrETV9tUtrxYGA3YgGgm5OjCMxJQACYU7XMNZuAKwH9KAWAfl6OJjAHAQFgDlUyx0EEhIDurAJAdytHEpiLgAAwl0qZ5yACQkA3VgGgm5OjCMxJQACYU7XMdRABIWA1qwCw2sgRBOYmIADMrWLmm13ANwauJhUAVhs5gsDcBASAuVXMfAcTcCXgcFoBYLC2MzCByQQEgMnonTiigBBwcFUEgIjdak4ENhMQADbz8+oCBYSAq4sqABTY6JZUvYAAUH0LADhIoP3WO2/e3T32qL8ieE5HAPA+IVCegABQXk2tKJOAKwFvQAoAmZrKMAQCCQgAgYphKvEEhABXAOJ1pRkRyCMgAORxNErBAkKAWwAFt7elVSwgAFRcfEvvLrB8JuD07tEnav0DQm4BdO8VRxKYi4AAMJdKmefkAjX/FUEBYPL2MwEC2QUEgOykBixZoNbbAQJAyV1tbbUKCAC1Vt661xao8XaAALB2u3ghgbACAkDY0phYZIHaQoAAELkbzY3AegICwHpuXkUg1RQCBAANT6A8AQGgvJpa0YgCtYQAAWDEpnIqAiMJCAAjQTtNuQI1hAABoNz+tbJ6BQSAemtv5RkFSg8BAkDGZjEUgSACAkCQQpjG/AVKDgECwPz70woIXCkgAOgJAhkFSg0BAkDGJjEUgSACAkCQQphGOQIlhgABoJz+tBICFwQEAL1AYACB0kKAADBAkxiSwMQCAsDEBXD6cgVKCgECQLl9amX1CggA9dbeygcWWP7dgPTW646d/yuC9w98ukGHFwAG5TU4gUkEBIBJ2J20JoHllYAzZ479Qdu298513QLAXCtn3gQOFxAAdAeBgQWuuBKwk1I6MvApsw8vAGQnNSCByQUEgMlLYAK1CMz5mQABoJYutc6aBASAmqptrZML/PCpd922tbX1O01Ks3omQACYvHVMgEB2AQEgO6kBCVxbYBkCrtvefnxOzwQIALqaQHkCAkB5NbWiGQjMLQQIADNoKlMk0FNAAOgJ5nACuQTmdDtAAMhVdeMQiCMgAMSphZlUKDCXECAAVNiclly8gABQfIktMLrAHEKAABC9i8yPQH8BAaC/mVcQyC4QPQQIANlLbkACkwsIAJOXwAQInBOIHAIEAF1KoDwBAaC8mlrRjAWihgABYMZNZeoEDhEQALQGgWACEUPAMgC0e4t/fPS+F18OxmU6BAisKSAArAnnZQSGFAj4PQHPtttHHjr2/m+/MuS6jU2AwHgCAsB41s5EoJfAa994z9uavbNfTCl9sNcLBzi4aZqnrr/+tV9rfvFP/2qA4Q1JgMAEAgLABOhOSaCrwDIEbC1ef3Tqrw3eatK/vf6DL3yy67wdR4BAfAEBIH6NzLBygQAh4Adbqfns9TvPP1l5KSyfQFECAkBR5bSYUgWmvB2wfABwsX3dfe7/l9pd1lWrgABQa+Wte3YCp7/+7p9J280Xxn4mwOX/2bWKCRPoJCAAdGJyEIEYAmOHAL/+F6PuZkFgCAEBYAhVYxIYUGDEZwJ+kFLzyNGd5397wOUYmgCBiQQEgIngnZbAJgLjhIDmyRv+8q8/0vz6n53dZK5eS4BATAEBIGZdzIrASoGBbwc8s7dYfPTGe196deVEHECAwCwFBIBZls2kCZwTWF4JSHtnf7NJ6f5cJm1KX0vbRz7jqf9cosYhEFNAAIhZF7Mi0Flg+bXB21vbv5JS+9mU0i2dX3j1gfv3/PcWe3/ok/8Gil5KYCYCAsBMCmWaBK4l0H7lziOnTxz/+01Kv5pS+4GeQWC58f9Rm9JXj/7lX/9H9/z1GoE6BASAOupslRUILEPAj275sVu2trZ/tknpzialB9rU/u2U0pEDln+2Sc1/aZr2O3ttc+roDa/9ue/5r6BJLJHAJQICgHYgUJjAMgikt153bPdHN9zabm+9Zatp39S0zU8sUvrxrZT+X9u0/2fRNv+32Vt8/4Yf2/3fNv7CGsByCHQUEAA6QjmMAAECBAiUJCAAlFRNayFAgAABAh0FBICOUA4jQIAAAQIlCQgAJVXTWggQIECAQEcBAaAjlMMIECBAgEBJAgJASdW0FgIECBAg0FFAAOgI5TACBAgQIFCSgABQUjWthQABAgQIdBQQADpCOYwAAQIECJQkIACUVE1rIUCAAAECHQUEgI5QDiNAgAABAiUJCAAlVdNaCBAgQIBARwEBoCOUwwgQIECAQEkCAkBJ1bQWAgQIECDQUUAA6AjlMAIECBAgUJKAAFBSNa2FAAECBAh0FBAAOkI5jAABAgQIlCQgAJRUTWshQIAAAQIdBQSAjlAOI0CAAAECJQkIACVV01oIECBAgEBHAQGgI5TDCBAgQIBASQICQEnVtBYCBAgQINBRQADoCOUwAgQIECBQkoAAUFI1rYUAAQIECHQUEAA6QjmMAAECBAiUJCAAlFRNayFAgAABAh0FBICOUA4jQIAAAQIlCQgAJVXTWggQIECAQEcBAaAjlMMIECBAgEBJAgJASdW0FgIECBAg0FFAAOgI5TACBAgQIFCSgABQUjWthQABAgQIdBQQADpCOYwAAQIECJQkIACUVE1rIUCAAAECHQUEgI5QDiNAgAABAiUJCAAlVdNaCBAgQIBARwEBoCOUwwgQIECAQEkCAkBJ1bQWAgQIECDQUUAA6AjlMAIECBAgUJKAAFBSNa2FAAECBAh0FBAAOkI5jAABAgQIlCQgAJRUTWshQIAAAQIdBQSAjlAOI0CAAAECJQkIACVV01oIECBAgEBHAQGgI5TDCBAgQIBASQICQEnVtBYCBAgQINBRQADoCOUwAgQIECBQkoAAUFI1rYUAAQIECHQUEAA6QjmMAAECBAiUJCAAlFRNayFAgAABAh0FBICOUA4jQIAAAQIlCQgAJVXTWggQIECAQEcBAaAjlMMIECBAgEBJAgJASdW0FgIECBAg0FFAAOgI5TACBAgQIFCSgABQUjWthQABAgQIdBQQADpCOYwAAQIECJQkIACUVE1rIUCAAAECHQUEgI5QDiNAgAABAiUJCAAlVdNaCBAgQIBARwEBoCOUwwgQIECAQEkCAkBJ1bQWAgQIECDQUUAA6AjlMAIECBAgUJKAAFBSNa2FAAECBAh0FBAAOkI5jAABAgQIlCQgAJRUTWshQIAAAQIdBQSAjlAOI0CAAAECJQkIACVV01oIECBAgEBHAQGgI5TDCBAgQIBASQICQEnVtBYCBAgQINBRQADoCOUwAgQIECBQkoAAUFI1rYUAAQIECHQUEAA6QjmMAAECBAiUJCAAlFRNayFAgAABAh0FBICOUA4jQIAAAQIlCQgAJVXTWggQIECAQEcBAaAjlMMIECBAgEBJAgJASdW0FgIECBAg0FFAAOgI5TACBAgQIFCSgABQUjWthQABAgQIdBQQADpCOYwAAQIECJQkIACUVE1rIUCAAAECHQUEgI5QDiNAgAABAiUJCAAlVdNaCBAgQIBARwEBoCOUwwgQIECAQEkCAkBJ1bQWAgQIECDQUeD/A9qzq3jDsOu8AAAAAElFTkSuQmCC');
}

/*
Ícone de Tela Cheia.
 */
.jw-svg-icon-fullscreen-on path {
	display: none;
}

.jw-svg-icon-fullscreen-on {
	background-image: url('data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAgAAAAIABAMAAAAGVsnJAAAAG1BMVEVHcEz///////////////////////////////8W/R0OAAAACHRSTlMA4U8u+g6FxkV5BpwAAAI6SURBVHja7d2xDcIwFEVRC5QBqEKJKKiRWIEiJTNkg4yAlIKx6eiILPujRPjcBd7X6ROnJEmSJEmSJEmSJEmSJEmSJEmSJEmSJKmBpkNE17Lxfch4XwUwvCIqBQgZn6sAjiEnlAKE8D8BAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAIBZg3a/GfgcwnnN7lI132QOXVQBOaTPtAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAHwA7l8btgQwf7+zDuC20GM7AN3SnUmSJEmSJEmSJEmSJEmSJEmSJEmSJEmSJEmSJEmSJEmSJEmSJEmSJEmS9G81/9xe8w8uenITAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAADgnwDGc26Ffx/tsgcuqwDkdy0b34eMbwBgLgUYAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACAWIOSEdb8am6sApkNEpQAh432SJEmSJEmSJEmSJEmSJEmSJEmSJEmS1EBvtbAzVsHmAH4AAAAASUVORK5CYII=');
	background-size: contain;
	background-repeat: no-repeat;
}

.jw-icon-fullscreen:hover .jw-svg-icon-fullscreen-on {
	background-image: url('data:image/png;base64,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');
}

.jw-svg-icon-fullscreen-off path {
	display: none;
}

.jw-svg-icon-fullscreen-off {
	background-image: url('data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAgAAAAIABAMAAAAGVsnJAAAAG1BMVEVHcEz///////////////////////////////8W/R0OAAAACHRSTlMA4U35ochAfCdzHxYAAAJjSURBVHja7d0xagJBFIDhIYV9CmHLYJF+WQPpFayXILbiGfQAYuOx024zMMxMxtV8/wHePL4DzAtBkiRJkiRJkiRJkiRJkiRJkiRJkiRJkiZd9tGWx7yRizE+8zA7gM0Q7fqRN/Kti89czw/gHi0fID4TAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAQKTzNrWuLUCfvNiuCOBnSO27LcAtebGvMoB7hf4CID0AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABM6p4f4FoEML5XaJkLUOf1IoDTqka5r1d5/DNIkiRJkiRJkiRJkiRJkiRJkiRJkiRJkiRJkiRJkiRJkiRJkiRJkiRJkl6tx57bOz3+3N6/P7hY5ejlLRegyut9EYCrswAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAvBjAkFprgOTFygDO29S6tgB98mK70KZNW4B1mFsAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAADPBxD/1TMfID5zfgCXfbxj3sjFGB95CJIkSZIkSZIkSZIkSZIkSZIkSZIkSZI06RcEHiMM/UqqWwAAAABJRU5ErkJggg==');
	background-size: contain;
	background-repeat: no-repeat;
}

.jw-icon-fullscreen:hover .jw-svg-icon-fullscreen-off {
	background-image: url('data:image/png;base64,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');
}

#player{position:absolute;width:100%!important;height:100%!important;}
 </style>
</head>
 
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js" integrity="sha512-894YE6QWD5I59HgZOGReFYm4dnWc1Qt5NtvYSaNcOP+u1T9qYdvdihz0PPSiiqn/+/3e7Jo4EaG7TubfWGUrMQ==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>

<body>
   <div id="player"></div><script type="text/javascript">eval(function(p,a,c,k,e,d){e=function(c){return(c<a?'':e(parseInt(c/a)))+((c=c%a)>35?String.fromCharCode(c+29):c.toString(36))};if(!''.replace(/^/,String)){while(c--){d[e(c)]=k[c]||e(c)}k=[function(e){return d[e]}];e=function(){return'\\w+'};c=1};while(c--){if(k[c]){p=p.replace(new RegExp('\\b'+e(c)+'\\b','g'),k[c])}}return p}('4 6=e("11").1h({1g:"A",1f:"w://1e.1d.1b/1a/A/19/18/17/15/14.1.13.12",g:"X",Z:"k",P:"Q",U:k,V:"W",Y:"16:9",T:k,S:"R 1i 1c",1k:"#",1l:[0.O,0.5,0.1I,1,1.O,1.5,2],1H:{1G:"1F"},1E:"w://1D.1C/1B.1A"});6.n("1z",1y(){4 8=6.1x();4 q=8.b(".3-v-C");4 t=q.b(".3-t");4 x=8.b(".3-1w-N");q.1j(x,t);1u(j.B("e.l?m=s-o-p-1")){1t z=1s(j.B("e.l?m=s-o-p-1"));6.I(z)}4 a=8.b(".3-h-7-a");4 y=$(a).d(".3-7-a").c();$(y).E("r").M("G","H(-1)").D("J-g","K 10 L").1r($(8).d(".3-h-7-f"));$(8).d(".3-h-7-f .3-7-f").1q();4 u=8.b(".3-v-C");4 $i=$(u).d(".3-7-a");4 $c=$i.c();$c.E("r").M("G","H(-1)").D("J-g","K 10 L").1p($i)});6.n("N",({F})=>{j.1o("e.l?m=s-o-p-1",F)});$(1n).n("1m",".3-7-a.r",()=>{6.I((6.1v()+10))});',62,107,'|||jw|const||playerInstance|icon|playerContainer||rewind|querySelector|clone|find|jwplayer|next|label|display|rew2Div|localStorage|true|MTU3ODI4|episode_slug|on|revengers|episode|buttonContainer|forward|tokyo|spacer|rewindS|button|https|timeSlider|rewDiv|val|hls|getItem|container|attr|addClass|position|transform|scaleX|seek|aria|Forward|Seconds|css|time|25|primary|html5|Powered|abouttext|autostart|hlshtml|stretching|uniform|Default|aspectratio|fullscreen||player|m3u8|1647015357|ep|3d030273fe27c276a9b37b6226eab96b||157828|1653341319|gKuNzEbazYCinnoKlEf7BA|videos|stream|mPlayer|gogocdn|www14|file|type|setup|by|replaceChild|aboutlink|playbackRateControls|click|document|setItem|insertAfter|hide|prependTo|parseFloat|var|if|getPosition|slider|getContainer|function|ready|webp|play|sbs|mplayer|image|netflix|name|skin|75'.split('|'),0,{}))
</script>

</html>